# CVE-2022-24693
## Description
Baicells Nova436Q and Neutrino 430 devices with firmware through QRTB 2.7.8 have hardcoded credentials that are easily discovered, and can be used by remote attackers to authenticate via ssh. (The credentials are stored in the firmware, encrypted by the crypt function.)

## CVSS Score
[CVSS 9.8](https://nvd.nist.gov/vuln/detail/CVE-2022-24693)

## Vulnerability Type
[CWE-284: Improper Access Control](https://cwe.mitre.org/data/definitions/284.html) 

## Vendor of Product
BaiCells

## Affected Product Code Base
* NOVA436Q - QRTB 2.7.8 (Likely all builds before 2.9.x) 
* NEUTRINO430 - QRTB 2.7.8 (Likely all builds before 2.9.x) 

## Affected Component
Usernames and Passwords are static in the firmware, encrypted using crypt(), and so are crackable.

### Attack Type
Remote

### Impact Code execution
True

### Impact Denial of Service
True

### Impact Escalation of Privileges
True

### Impact Information Disclosure
True

### Attack Vectors
Out of the box, the firmware has static usernames and passwords.

## Reference
* https://na.baicells.com/Service/Firmware
* https://img.baicells.com//Upload/20211230/FILE/BaiBS_QRTB_2.7.8.IMG.IMG
* https://img.baicells.com//Upload/20210909/FILE/98d2752f-6e83-49b1-9dab-d291e9023db6.pdf

## Has vendor confirmed or acknowledged the vulnerability?
Yes: https://community.na.baicells.com/t/important-security-notice-for-nova-436q-430-neutrino-430/1729

## Discoverer
Luke Jenkins

## Timeline
* 2021-12-07 - Email to Baicells requesting that they publish a Vulnerability Disclosure Policy.
* 2021-12-08 - Email discussion with Baicells including a draft copy of a Vulnerability Disclosure Policy and a source of PGP keys for a point of contact.
* 2021-12-08 - PGP encrypted email sent to point of contact with details of the vulnerability.
* 2022-02-08 - Baicells notification received that they had fixed the issue in their upcoming QRTB 2.9 software release.
* 2022-03-22 - Baicells requests that the plaintext passwords not be included on this page.
* 2022-03-23 - Email reply to Baicells pointing out that not including the password would only provide the delusion of security.
* 2022-03-28 - Bailcells posts QRTB 2.9.10 software version with fix for this issue.
* 2022-03-28 - This page, which had been blank, modified to include details of the vulnerability.
* 2022-03-28 - Request sent to Mitre requesting that they publish CVE-2022-24693.
* 2022-03-28 - Email from Baicells requesting that removal the plaintext passwords from this page.
* 2022-03-28 - Reply to Baicells declining their request based on disclosure timeline.
* 2022-03-29 - Email notification from mitre's CVE Assignment Team request to publish CVE-2022-24693 had been received and processed.
* 2022-03-29 - Phone call from UETN leadership requesting that Baicell's request be honored.
* 2022-03-29 - Email sent to Baicells notiying them that their request to remove the passwords from the main page would be honored , but that the passwords would still available in the git history and via archive.org.
* 2022-03-29 - Plain text passwords obfuscated from this page.
* 2022-03-30 - Email from Baicells that they were posting notice of this vulnerability to their website and that they are starting to notifying customers.
* 2022-03-30 - Email from Baicells sent to a customer email list warning of the security vulnerability and linking to this notice and to fixed software. 

## Details:
* User `admin` password of `Baicells` stored using unix crypt() DES algorithm.
* Undocumented & non-configurable user `anonymous` password of `pqmz325` stored using unix crypt() DES algorithm.
* Undocumented, non-configurable (but seemingly unusable for ssh) user `root` password of `qpa;10@)` stored using unix crypt() DES algorithm. Vendor claims this is unique per device, but this hasn't been confirmed.


## How to reproduce
1. Download firmware from the vendor's website, no login needed. As a customer, I love this; but from a security point of view it is important to understand how easy it is for a bad actor to get the firmware.
2. Run [binwalk](https://github.com/ReFirmLabs/binwalk) on the firmware image, a tool that extracts all of the files contained in the firmware. Snag the usernames and password hashes from /etc/passwd and /etc/shadow.
3. Use [hashcat](https://hashcat.net/hashcat/) to crack the hashes. In addition to being designed with 30+ year old CPUs in mind, the unix crypt() function "protecting" these passwords also limits them to 8 characters. Passwords go pop.
4. Credentials for the anonymous user can be used to ssh into the device. I'll save you the trouble of a port scan or looking through the config files from step 2, dropbear is listening on port 27149.


## Notes
This is my first published CVE, so please excuse (or pull request) any errors. 

Thanks to the folks at UETN for the assistance and backing on this one. 

Also thank you to the staff of Baicells NA for working with me on correcting this issue.
