const http = require('http');
const Dicer = require('./dicer'); // Importing from local source
const PORT = 3000;

http.createServer((req, res) => {
  if (req.method === 'POST' && req.headers['content-type']) {
    const contentType = req.headers['content-type'];
    const match = contentType.match(/boundary=(?:"([^"]+)"|([^;]+))/i);
    const boundary = match && (match[1] || match[2]);

    if (!boundary) {
      res.writeHead(400);
      return res.end('No boundary found in content-type header');
    }

    const dicer = new Dicer({ boundary });

    dicer.on('part', (part) => {
      let partData = '';
      part.on('header', (header) => {
        console.log('Part header:', header);
      });

      part.on('data', (data) => {
        partData += data.toString();
      });

      part.on('end', () => {
        console.log('Part data:', partData);
      });
    });

    dicer.on('finish', () => {
      res.writeHead(200);
      res.end('Multipart data processed successfully');
    });

    req.pipe(dicer);
  } else {
    res.writeHead(404);
    res.end('Only POST requests with multipart/form-data are supported');
  }
}).listen(PORT, () => {
  console.log(`Server running at http://localhost:${PORT}`);
});
