# CVE-2022-24434 – PoC for Dicer

This repository contains a Proof-of-Concept (PoC) for **CVE-2022-24434**, a vulnerability affecting the [Dicer](https://www.npmjs.com/package/dicer) npm package.  
> **PoC target version:** **0.3.1** (ensure the dicer code used is exactly v0.3.1)

---

## 📂 Project Structure

Make sure the directory is structured like this:

.
├── dicer/ # Cloned Dicer repo (must be v0.3.1)
├── server.js # Vulnerable server script
└── dicer_poc.js # Exploit PoC script

yaml
Copy code

---

## ⚙️ Setup

### Option A — clone the repository and checkout v0.3.1 (recommended if using the repo)
```bash
git clone https://github.com/mscdex/dicer.git
cd dicer

# fetch tags and switch to v0.3.1 (tag name may be "v0.3.1" or "0.3.1")
git fetch --all --tags
# try the tag checkout (if tag is 'v0.3.1')
git checkout tags/v0.3.1 -b poc-0.3.1 || git checkout tags/0.3.1 -b poc-0.3.1

npm install       # install dicer repo dependencies if needed
cd ..
Option B — install the package at version 0.3.1 (if you prefer using npm instead of cloning repo)
If you prefer not to clone the full repository, you can create a local node_modules with the specific version:

bash
Copy code
mkdir tmp_project && cd tmp_project
npm init -y
npm install dicer@0.3.1
# copy the installed package folder node_modules/dicer into the parent folder as 'dicer'
cp -R node_modules/dicer ../dicer
cd ..
rm -rf tmp_project
Important: The PoC is written to run against the dicer source folder inside this project root. Ensure the folder named dicer in the root corresponds to version 0.3.1.

└── poc/
    ├── dicer/              # Cloned Dicer repo (must be v0.3.1)
    ├── server.js           # Vulnerable server script (place here)
    └── dicer_poc.js        # Exploit PoC script (place here)

▶️ Running the PoC
Start the vulnerable server:

bash
Copy code
node server.js
In a separate terminal, run the exploit PoC:

bash
Copy code
node dicer_poc.js
🧩 Notes
The PoC depends on behavior present in dicer v0.3.1. Using newer or patched versions may not reproduce the issue.

If you cloned the repo and cannot find the tag, check git tag to list available tags. If there is no 0.3.1 tag, use the npm-install method above and confirm the package.json inside dicer/ shows version 0.3.1.

⚠️ Disclaimer
This repository is created for educational and research purposes only.
Do not use this PoC against systems without explicit authorization.
The author is not responsible for any misuse or damages caused.
