# CVE-2022-23884
There is a network-layer vulnerabilities in the official server of Minecraft: Bedrock Edition (aka Bedrock Server),which allow attacker to launch a DoS attack.

`CVE-2022-23884` Mojang Bedrock Dedicated Server 1.16.0-1.18.12 is affected by an large loop and crash server caused by PurchaseReceiptPacket::_read (packet deserializer).

# Details
`CVE-2022-23884` affects Bedrock Server 1.16.0-1.18.12.
It is caused by `PurchaseReceiptPacket::_read`(packet deserializer).
```C++
//pseudo-code
u32 Num = readUnsignedVarInt();
 for ( i = 0; i < (unsigned int)Num; ++i )
  {
      ...
  }
```
Attackers can choose special Num (e.g. `0xffffffff`) Large sizes will cause a large loop(blocks the main thread) and crash server.

# PoCs
**Disclaimer: PoCs are only excepted to be used for testing whether your server is vulnerable.Providers assume no liability and are not responsible for any misuse or damage caused by these programs. Use at your own risk.**  
CVE-2022-23884: `python replay.py <IP> <Port> purchase.pkt`  

# Patches
Latest Bedrock Server(1.18.12.01) does not include patches for CVE-2022-23884. There are third-party patches.  

---
Patch for `CVE-2022-23884`:  
You can hook `PurchaseReceiptPacket::_read` and return false.
(The packet is only used for partnered servers,So BDS does not need to do any processing, just return false) 
This [file](https://github.com/LiteLDev/LiteLoaderBDS/blob/a21c3b4220170e29a82dba1460118dbbd041a273/LiteLoader/Main/BuiltinBugFix.cpp#L47) in LiteLoader fixed `CVE-2022-23884`.  
Update to LiteLoader 2.0.5 or later to fix this issue.
