# ✅ CVE-2022-22077 exploitation framework RTCore64.sys:

<img width="1328" height="1328" alt="image" src="https://github.com/user-attachments/assets/55f73f43-8bab-4fdb-84c3-011ca24d51c2" />

This document provides a comprehensive overview of the CVE-2022-22077 exploitation framework, a sophisticated BYOVD (Bring Your Own Vulnerable Driver) attack toolkit that targets the RTCore64.sys driver vulnerability. This framework demonstrates advanced Windows kernel exploitation techniques for educational and security research purposes.

The material covered includes the vulnerability's technical foundation, the framework's architecture, and the integration with the broader LazyOwn RedTeam toolkit. For detailed vulnerability analysis, see Vulnerability Analysis. For specific implementation details of individual components, see Exploitation Framework.

<img width="513" height="883" alt="image" src="https://github.com/user-attachments/assets/36b635a6-86c8-4b93-a6b2-15286897e1a2" />

## 🚨 CVE-2022-22077 — MSI Center / Dragon Center — Arbitrary Memory Read/Write via RTCore64.sys

CVE-2022-22077 is a high-severity vulnerability (CVSS score 7.8) affecting the RTCore64.sys driver distributed with MSI Center and Dragon Center applications. The vulnerability stems from exposed IOCTL interfaces that allow unprivileged users to perform arbitrary physical memory reads and writes, effectively bypassing all Windows kernel security mechanisms.

<img width="1724" height="246" alt="image" src="https://github.com/user-attachments/assets/2f13aaf2-97ee-478c-b9aa-e81a958f3ea0" />

## Key Impact Areas:

- Local privilege escalation to SYSTEM
- EDR/AV bypass capabilities
- Kernel-mode code execution
- Rootkit installation potential

<img width="1276" height="734" alt="image" src="https://github.com/user-attachments/assets/82db2c7f-70b0-436d-b909-43c8ffad7633" />

## Stages

<img width="682" height="859" alt="image" src="https://github.com/user-attachments/assets/a8dc2a4f-d9b0-4837-8b90-6f9d656ba50a" />

### Stage 1: Environment Preparation

- File: install.sh - Sets up mingw-w64 cross-compilation environment
- File: build.sh - Compiles Windows executables from Linux host
- Integration: LazyOwn framework configuration via CVE-2022-22077.yaml

### Stage 2: Automated Deployment

- File: payload.ps1 - PowerShell script handling:
- Privilege validation (SeLoadDriverPrivilege)
- VBS/HVCI compatibility checks
- Driver and exploit download from remote server
- Windows service creation and management

### Stage 3: Kernel Exploitation

- File: exploit.c - Native code implementing:
- RTCore64.sys device communication
- SYSTEM process token extraction
- Current process token replacement
- Privilege escalation validation

<img width="813" height="864" alt="image" src="https://github.com/user-attachments/assets/548542d5-01a3-4325-9581-9c6a689d52ef" />

## Memory Manipulation Architecture

The framework implements kernel memory access through a structured approach using the RTCore64.sys driver vulnerabilities:

<img width="1290" height="833" alt="image" src="https://github.com/user-attachments/assets/8efe4d10-0718-477e-ae90-3875f73deb49" />

## Article

![descarga 2](https://github.com/user-attachments/assets/12e4e0e1-5636-44a2-b2e2-4d4763fb4068)

### The RTCore64 Chronicles: When Your GPU Tuner Becomes a Kernel Assassin (And Why That’s a Feature, Not a Bug)


> By: grisun0, Chief Architect of Kernel Chaos & Part-Time Driver Whisperer - LazyOwn RedTeam

7 min read · Published at 3:33 AM because “HVCI? Never met her.”

“The best way to own a system is to ask its own driver for permission — politely, with IOCTLs.”
— grisun0, probably while reverse-engineering MSI Afterburner in his underwear

Let’s skip the part where I pretend this is normal.

If you’re reading this, you’re either:

- A red teamer who just turned RTCore64.sys into a kernel backdoor while sipping matcha,
- A blue teamer staring at \\.\RTCore64 in ProcMon thinking, “Why does my GPU need to read PsInitialSystemProcess?”,
- Or someone who Googled “how to become SYSTEM with a gaming driver” and ended up here.
(Spoiler: It’s not only possible — it’s elegant.)

Welcome to LazyOwn RedTeam™, where we don’t bypass security — we invite it to dinner and then steal its wallet.

Today, I introduce you to RTCore64.sys — not a driver, not a tool, but a fully operational kernel exploit disguised as a utility for overclocking your RTX 3090.

And yes — there’s a twist.

Spoiler: It still uses cmd.exe.
Bigger spoiler: Now it uses beacon.exe too.
Even bigger spoiler: Both are now running with NT AUTHORITY\SYSTEM privileges, thanks to a driver that thought “arbitrary kernel memory access” was a quality-of-life feature.

🕳️ What Is RTCore64.sys? (Or: “How to Turn MSI Afterburner Into a Ring 0 Backdoor”)
Imagine installing a driver to tweak your GPU voltage… and accidentally giving yourself full read/write access to kernel memory.

This is CVE-2022–22077 — a vulnerability so beautifully reckless, it makes capcom.sys look like a shy librarian.

While capcom.sys asked nicely to execute your callback, RTCore64.sys just hands you the keys to the kingdom — no questions asked.

“Here’s an IOCTL. Write any address. Read any value. Go nuts.”
— MSI, probably

And because we’re professionals, we don’t just DeviceIoControl randomly. We steal SYSTEM tokens, patch EPROCESS structures, and spawn SYSTEM shells — all before your GPU hits 70°C.

### 🔧 How RTCore64.sys Works: A Symphony of IOCTLs and Impunity
Let me walk you through the five acts of this digital heist:

1. The Setup: “I’m Just a Gamer, Officer”
You download MSI Afterburner to overclock your GPU. Harmless, right?

Wrong.

Buried inside is RTCore64.sys — a signed, vulnerable driver that exposes IOCTLs like:

0x80002048 → Read kernel memory
0x8000204c → Write kernel memory
No validation. No sanity checks. Just raw, unfiltered power.

“Why sandbox when you can kernel?”
— MSI Engineering Team, 2019

2. The Load: “BYOVD? More Like Bring Your Own Gaming Rig”
You don’t even need to install MSI Afterburner.

Just:

sc create RTCore64 binPath=C:\Windows\Temp\RTCore64.sys type=kernel

sc start RTCore64

Boom. Kernel access unlocked.

Prerequisite: SeLoadDriverPrivilege (which you already have, because you’re that good).
Bonus: HVCI disabled (because who needs virtualization when you have style?).

3. The Exploit: “Token Stealing for Dummies (And Geniuses)”
Here’s the sequence:

CreateFileW(L"\\\\.\\RTCore64", ...) → Grab the golden ticket.
EnumDeviceDrivers() → Find ntoskrnl.exe base.
Parse PsInitialSystemProcess from disk → Get offset.
Read EPROCESS of SYSTEM → Steal its token.
Write token into your own process → Congratulations, you’re God.
CreateProcessW(L"beacon.exe", ...) → Spawn your payload as SYSTEM.
No shellcode. No ROP chains. Just pure, unadulterated kernel object manipulation.

4. The Cover-Up: “Logs? What Logs?”
wevtutil cl security

del C:\Windows\Temp\RTCore64.sys

sc delete RTCore64

Poof. Gone. Like a ghost who overclocked your RAM and vanished.

5. The Flex: “I Dumped LSASS With a Gaming Driver”
Once you’re SYSTEM:

tasklist /m mimilib.dll

eventcreate /t INFORMATION /id 1 /l APPLICATION /d “sekurlsa::logonpasswords”

type C:\Windows\System32\mimilsa.log

→ Domain Admin hashes? Check.
→ Plaintext passwords? Check.
→ Golden Tickets? Coming right up.

### 🛠️ Why RTCore64.sys Is the Red Teamer’s Swiss Army Knife
- ✅ Signed Driver — Bypasses Driver Signature Enforcement (until Microsoft revokes it — which they did, but who’s checking?).
- ✅ No HVCI? No Problem — Works beautifully on systems without virtualization-based security.
- ✅ Arbitrary Kernel R/W — Read PsInitialSystemProcess, write tokens, patch callbacks — the sky’s the limit.
- ✅ Minimal Footprint — Just a .sys and a tiny .exe. No PowerShell, no .NET, no fuss.
- ✅ Educational Goldmine — Want to learn DKOM, BYOVD, or token impersonation? This is your lab.

### 🎭 But Wait — There’s More: The LazyOwn Ecosystem
RTCore64.sys isn’t a lone wolf.
It’s a node in the LazyOwn RedTeam Framework — a modular, extensible, and slightly unhinged ecosystem of offensive tools.

Imagine this:

Generate shellcode with ShadowLink.
Obfuscate it with LazyAddons.
Deliver it via RTCore64.sys token theft.
Execute it as SYSTEM via CreateProcessW.
All orchestrated from a C2 that looks like a Steam download.
And the best part?
It’s all open-source.
Because transparency is the best opsec.

### 🎁 THE SURPRISE: A Beacon With a GPU
👉 Watch it in action (mentally, because I’m not filming this at 4 AM) just kidding grab popcorn and watch : 

[https://www.youtube.com/shorts/V2tqH53LRIw](https://www.youtube.com/shorts/V2tqH53LRIw)

Yes. That’s a Windows beacon.exe:

Spawned via RTCore64.sys token theft
Running as NT AUTHORITY\SYSTEM
Calling back to your C2
All while Task Manager says “Looks normal to me”
And it’s not even running as admin.
It’s just that good.

## 🛡️ Detection? Here’s How to Catch It (For Blue Teams)
I’m not just a red teamer. I’m a responsible red teamer. So here’s free intel:

## 🔍 YARA Rule (Basic IOC)
yara

rule RTCore64_Based_Kernel_Exploit {

meta:

author = “LazyOwn BlueTeam”

description = “Detects RTCore64.sys exploitation via known IOCTLs and patterns”

license = “GPLv3”

strings:

$driver_name = “RTCore64.sys” ascii wide

$ioctl_read = { 80 00 20 48 } // 0x80002048

$ioctl_write = { 80 00 20 4C } // 0x8000204c

$create_device = “CreateFileW” ascii

$device_path = “\\\\.\\RTCore64” ascii wide

$token_steal = “PsInitialSystemProcess” ascii

condition:

all of them

}

### 🕵️ Heuristic Alerts
Look for:

RTCore64.sys loaded outside of C:\Program Files (x86)\MSI Afterburner\
DeviceIoControl calls with 0x80002048 or 0x8000204c
Process token changes from low-priv to SYSTEM
sc create or sc start targeting RTCore64
PsInitialSystemProcess being read from kernel memory
If you see this combo?
You’ve been RTCore’d.

### ⚠️ Disclaimer (Because Reality Has Lawyers)
This tool is released for educational and ethical red teaming only.

Do not use it on systems you don’t own or lack explicit permission to test.

Misuse may result in:

Getting fired
Getting sued
Your GPU developing a god complex
Microsoft revoking your driver’s signature (again)
Your mom asking why you’re “hacking the government” again
I assume zero liability. You’re on your own, cowboy.

## 🔗 Links (Because Sharing Is Power)
- 📓 Wiki: [https://deepwiki.com/grisuno/CVE-2022-22077](https://deepwiki.com/grisuno/CVE-2022-22077)
- 🐙 GitHub: [https://github.com/grisuno/CVE-2022-22077](https://github.com/grisuno/CVE-2022-22077)
- 🧠 LazyOwn Framework: [https://github.com/grisuno/LazyOwn](https://github.com/grisuno/LazyOwn)
- 🌐 Web: [https://grisuno.github.io/LazyOwn/](https://grisuno.github.io/LazyOwn/)
- 🎥 Demo: [https://www.youtube.com/shorts/V2tqH53LRIw](https://www.youtube.com/shorts/V2tqH53LRIw) (mentally insert epic kernel exploit footage)
- 📓 Wiki: [https://deepwiki.com/grisuno/blacksandbeacon](https://deepwiki.com/grisuno/blacksandbeacon)
- 📰 Blog: [https://medium.com/@lazyown.redteam/black-sand-beacon-when-your-linux-box-starts-whispering-to-c2-in-aes-256-cfb-and-no-one-notices-105ca5ed9547](https://medium.com/@lazyown.redteam/black-sand-beacon-when-your-linux-box-starts-whispering-to-c2-in-aes-256-cfb-and-no-one-notices-105ca5ed9547)
- 🎤 Podcast: [https://www.podbean.com/eas/pb-qe42t-198ee9d](https://www.podbean.com/eas/pb-qe42t-198ee9d)
- 🐙 GitHub: [https://github.com/grisuno/beacon](https://github.com/grisuno/beacon)
- 🐙 GitHub: [https://github.com/grisuno/LazyOwn](https://github.com/grisuno/LazyOwn)
- 🩸 Patreon: [https://www.patreon.com/c/LazyOwn](https://www.patreon.com/c/LazyOwn)
- 🐙 GitHub: [https://github.com/grisuno/CVE-2022-22077](https://github.com/grisuno/CVE-2022-22077)
- 🧠 LazyOwn Framework: [https://github.com/grisuno/LazyOwn](https://github.com/grisuno/LazyOwn)
- 🌐 Web: [https://grisuno.github.io/LazyOwn/](https://grisuno.github.io/LazyOwn/)
- 📰 Blog: [https://medium.com/@lazyown.redteam](https://medium.com/@lazyown.redteam)
- 🎥 Videolog: [https://youtu.be/spgLpv3XkiA](https://youtu.be/spgLpv3XkiA)
- 🧪 QuantumVault: [https://quantumvault.pro/landing](https://quantumvault.pro/landing)
- 🧑‍💻 HTB: [https://app.hackthebox.com/users/1998024](https://app.hackthebox.com/users/1998024)
- ☕ Ko-fi: [https://ko-fi.com/grisuno](https://ko-fi.com/grisuno) (Buy me coffee. I’ll use it to fund more kernel exploits.)

### 🔚 Final Thoughts: Stay Sharp, Stay Sneaky, and Never Trust a GPU Tuner
Tools like RTCore64.sys exist not to break systems — but to reveal their fragility.

To train defenders.
To test detection logic.
To make your gaming PC the most dangerous device on the network.

So go forth.
Learn.
Test.
Break things (ethically).

And remember:

The best security is the kind that makes you question whether your graphics card is plotting against you.

> 🔐 grisun0, signing off — from a kernel debugger, probably inside your GPU’s VRAM.

### CVE-2022–22077
BYOVD
Token Impersonation
RTCore64.sys
Kernel Exploitation
Red Teaming
LazyOwn

P.S. If your GPU starts overclocking itself at 3 AM… you’re welcome. 🚀

🔗 [[ YOUTUBE DEMO ]](https://youtube.com/shorts/V2tqH53LRIw)

🔗 [CVE-2022-22077](https://nvd.nist.gov/vuln/detail/CVE-2022-22077?spm=a2ty_o01.29997173.0.0.1d61c921XdCRdQ) en NVD

🔗 [https://medium.com/@lazyown.redteam/the-rtcore64-chronicles-when-your-gpu-tuner-becomes-a-kernel-assassin-and-why-thats-a-feature-7ba63a285d36](https://medium.com/@lazyown.redteam/the-rtcore64-chronicles-when-your-gpu-tuner-becomes-a-kernel-assassin-and-why-thats-a-feature-7ba63a285d36)

🔗 [https://www.loldrivers.io/drivers/e32bc3da-4db1-4858-a62c-6fbe4db6afbd/](https://www.loldrivers.io/drivers/e32bc3da-4db1-4858-a62c-6fbe4db6afbd/)

🔗 [https://github.com/grisuno/beacon](https://github.com/grisuno/beacon)

🔗 [https://github.com/grisuno/LazyOwn/](https://github.com/grisuno/LazyOwn/)




![Python](https://img.shields.io/badge/python-3670A0?style=for-the-badge&logo=python&logoColor=ffdd54) ![Shell Script](https://img.shields.io/badge/shell_script-%23121011.svg?style=for-the-badge&logo=gnu-bash&logoColor=white) ![Flask](https://img.shields.io/badge/flask-%23000.svg?style=for-the-badge&logo=flask&logoColor=white) [![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)

[![ko-fi](https://ko-fi.com/img/githubbutton_sm.svg)](https://ko-fi.com/Y8Y2Z73AV)
