# CVE-2022-1257 PoC: McAfee Agent Database Credential Harvesting
Made by scottk817

This script is a PoC for **CVE-2022-1257**, a vulnerability in the McAfee Agent (Trellix Agent) when working with it's database. The vulnerability allows attackers to retrieve and decrypt credentials from the McAfee Agent database file (`ma.db`) due to improper encryption key handling.

## Disclaimer

This script is intended for educational purposes only. **Do not use it on systems you do not own or have explicit permission to test**. Unauthorized access to systems and data is illegal and unethical.

## Description

**CVE-2022-1257** as described by NIST:

> Insecure storage of sensitive information vulnerability in MA for Linux, macOS, and Windows prior to 5.7.6 allows a local user to gain access to sensitive information through storage in ma.db. The sensitive information has been moved to encrypted database files.

This script demonstrates how an attacker could exploit this vulnerability by:
1. Copying the `ma.db` file to a temporary location to avoid lock contention.
2. Extract the usernames and encrypted passwords stored in the database.
3. Decode the extracted passwords and then decrypt the extracted passwords using XOR and 3DES decryption.
4. Outputting the results in CSV format for further use.

## Prerequisites

- **Windows OS** (Windows 11)
- **PowerShell 5.1 or later**
- **`winsqlite3.dll`**: This DLL file must be available for SQLite operations, comes natively in Windows 11.

## Installation

1. Clone or download the repository.
2. Ensure `winsqlite3.dll` is available on your system, it comes natively with Windows 11.
3. Ensure that you have access to PowerShell.
4. Ensure you have access to the McAfee Agent database (`ma.db`). This is typically located at `C:\ProgramData\McAfee\Agent\DB\ma.db`.

## Usage

Run the script in PowerShell with the following command:

```powershell
.\CVE-2022-1257.ps1
```

The script will output the usernames and decrypted passwords from the database in CSV format:

```csv
Username,Password
user1,password1
user2,password2
```

If you are using this in an assessment, it may be valuable to sanatize the script and obfuscate with [Invoke-Obfuscate](https://github.com/danielbohannon/Invoke-Obfuscation)

## References

- [CVE-2022-1257](https://nvd.nist.gov/vuln/detail/cve-2022-1257)
- [McAfee Sitelist Password Decryption Tool](https://github.com/funoverip/mcafee-sitelist-pwd-decryption/blob/master/mcafee_sitelist_pwd_decrypt.py)
- [Abusing McAfee Vulnerabilities and Misconfigurations](https://mrd0x.com/abusing-mcafee-vulnerabilities-misconfigurations/)
- [TryHackMe: Breaching Active Directory (This is where I first learned about this vulnerability)](https://tryhackme.com/room/breachingad)

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.