#include "util.h"

int32_t make_queue(key_t key, int msgflg) {
    int32_t result;
    if ((result = msgget(key, msgflg)) == -1) {
        perror("msgget failure");
        exit(-1);
    }
    return result;
}

ssize_t get_msg(int msqid, void *msgp, size_t msgsz, long msgtyp, int msgflg) {
    ssize_t ret;
    ret = msgrcv(msqid, msgp, msgsz, msgtyp, msgflg);
    if (ret < 0) {
        perror("msgrcv");
        exit(-1);
    }
    return ret;
}

ssize_t get_msg_no_err(int msqid, void *msgp, size_t msgsz, long msgtyp, int msgflg) {
    return msgrcv(msqid, msgp, msgsz, msgtyp, msgflg);
}

void send_msg(int msqid, void *msgp, size_t msgsz, int msgflg) {
    if (msgsnd(msqid, msgp, msgsz, msgflg) == -1) {
        perror("msgsend failure");
        exit(-1);
    }
    return;
}
