# CVE-2022-0169 — WordPress Photo Gallery SQLi PoC

This is a simple Python proof-of-concept (PoC) for **CVE-2022-0169**, an SQL injection vulnerability in the WordPress Photo Gallery plugin.

---

## What it does

* Checks the WordPress version (if available)  
* Exploits the vulnerable `admin-ajax.php` endpoint  
* Dumps `wp_users` usernames and password hashes  
* Saves results in timestamped folders  
* Prompts you to crack them with hashcat if you want

This tool is for **educational purposes only**. Use responsibly! Like you would listen to this.. 😆

---

##  🤌Usage

### 🖕 **Single target**

```bash
python3 exploit.py -u http://target.com
```

### 🖐️ **Multiple targets**

```bash
python3 exploit.py -f targets.txt
```

---

## 🕺 Options

| Option     | Description                                      |
|------------|--------------------------------------------------|
| `-u`       | Single target URL                                |
| `-f`       | File with list of targets                        |
| `-p`       | Proxy (e.g., `http://127.0.0.1:8080`)            |
| `-t`       | Number of threads (default: 5)                   |
| `-w`       | Choose wordlist for hashcat (default: rockyou.txt) Make sure that rockyou.txt is gunzipped!|

**Example:**

```bash
python3 exploit.py -u http://victim.com -w /usr/share/wordlists/rockyou.txt
```

---

**Requirements**

```bash
requests
argparse
colorama
```

## 🦠 Results

- Dumps are saved in `results/YYYYMMDD_HHMMSS/`
- One HTML dump per target
- Extracted hashes in separate files for easy cracking

When hashes are found, you’ll be asked:
```
Crack the hashes with hashcat now? [Y/N]:
```
If you hit `Y`, hashcat will run automatically using your selected wordlist.

---

## 🔫 Example attack flow

1. Run the script on your target(s).  
2. Check the `results/` folder for dumps and hashes.  
3. Crack them with hashcat:
   ```bash
   hashcat -m 400 -a 0 results/YYYYMMDD_HHMMSS/hashes.txt /usr/share/wordlists/rockyou.txt
   ```

---

## 📢 Disclaimer

This tool is for **educational and authorized testing** only.
You are solely responsible for how you use it.
Always get permission before scanning or exploiting any system.

Stay cyberpunk.  
**— X3RX3S**
