# CVE-2021-45010
🐍 Contrived Python PoC Exploit for [CVE-2021-45010](https://nvd.nist.gov/vuln/detail/CVE-2021-45010).
Tiny File Manager < 2.4.7

## Usage
```bash
usage: main.py [-h] -u URL -l USERNAME -p PASSWORD [-g GUI_PATH] [-r FS_RELPATH]

options:
  -h, --help            show this help message and exit
  -u URL, --url URL     Base URL
  -l USERNAME, --username USERNAME
                        Username
  -p PASSWORD, --password PASSWORD
                        Password
  -g GUI_PATH, --gui-path GUI_PATH
                        GUI relative path for upload (default: /)
  -r FS_RELPATH, --fs-relpath FS_RELPATH
                        Filesystem relative path (from web root) to write to
```

### GUI Relative Path
Tiny File Manager checks the relative path (as seen in the GUI) for write permissions before attempting the upload.  In some cases a writable relative path in the GUI must be found before attempting to leverage the directory traversal
```php
  // tinyfilemanager.php (2.4.3)
  $targetPath = $path . $ds;
    if ( is_writable($targetPath) ) {
        $fullPath = $path . '/' . $_REQUEST['fullpath'];
```
### Filesystem Relative Path
If the actual web root is not writable by the running user, specify the relative path to one that is.

### Installation 
```bash
python3 -m pip install cve_2021-45010-1.0.0-py3-none-any.whl
```
[Download Latest Release](https://github.com/BKreisel/CVE-2021-45010/releases/download/1.0.0/cve_2021_45010-1.0.0-py3-none-any.whl)

## Demo
[![demo](https://asciinema.org/a/546897.svg)](https://asciinema.org/a/546897?autoplay=1)
