# Roundcube CVE-2021-44026, a SQL injection

This repository contains a demo exploit for an [SQL injection in Roundcube](https://pentest-tools.com/blog/roundcube-exfiltrating-emails-with-cve-2021-44026).

**Disclaimer**:

This code is intended solely for educational purposes and to assist security teams in identifying vulnerabilities in their Roundcube instances.
It should only be used in ethical hacking engagements in which the security professional has written authorization to ethically exploit the target(s) included in the scope.
The authors are not liable for any misuse or illegal use of this exploit code.

## Usage

```shell
usage: exploit.py [-h] smtp_server smtp_port sender_email sender_password target_email c2_server

Roundcube CVE-2020-35730 & CVE-2021-44026 exploit  

positional arguments:

  smtp_server      Sender SMTP server name

  smtp_port        Sender SMTP server port

  sender_email     Sender email address

  sender_password  Sender email password for logging into the SMTP server

  target_email     Target email address

  c2_server        The URL on which the C2 server will listen

  

optional arguments:

  -h, --help       show this help message and exit
```

When ran, the code starts a Flask server, `c2_server` in the code, which does the exploit in two steps:

1. It sends an email to a target from a given sender address. This email contains an exploit for another Roundcube vulnerability, an XSS tracked as [CVE-2020-35730](https://nvd.nist.gov/vuln/detail/CVE-2020-35730). We use it to send the requests necessary for the SQL injection from an authenticated session. All the JavaScript code that runs on the client side is in`static/fetcher.js`
2. The JavaScript code extracts all the sessions from the database and sends them back to the C2 server as a _VCARD_. On the server side, the session variables are extracted from the _VCARD_. For each authenticated session the code extracts the most recent emails received.

Note: You can use a Gmail account as the sender's email. Use `stmp.gmail.com` for the server and `587` for the port. Configure a password just for this usage by following the guide [here](https://support.google.com/mail/answer/185833?hl=en#zippy=).
