# CVE-2021-43229 Walkthrough

## Public information

`Windows NTFS` Elevation of Privilege Vulnerability

Unique from:
- CVE-2021-43230
- CVE-2021-43231

Patch: Dec 14, 2021

According to `@AravGarg3` on `Twitter`, `CVE-2021-43229` seems to be exploitable and related to an `integer overflow`.

***Source**: https://twitter.com/AravGarg3/status/1479447843458863104*

## Windows 10 versions

| Minor versions of Windows 10 | Release dates
| ---------------------------- | -------------
|   1387                       | 11/22/2021
|   1415                       | 12/14/2021

## First part - Diffing

Using `BinDiff` with `IDA Pro`, patch diffing result with the following changes:
|     | Simi | Conf | Function                               | Info
| --- | ---- | ---- | -------------------------------------- | -------
| NOK | 0.98 | 0.99 | NtfsCommonSetInformation$fin$0         | Jump modifications
|     | 0.97 | 0.99 | NtSetShortNameInfo                     |
|     | 0.96 | 0.99 | NtfsUpdateSecurity                     |
| NOK | 0.91 | 0.94 | NtfsRenameToPrivateDir$fin$1           | Jump modifications
|     | 0.89 | 0.98 | NtfsInitializeFileInDirectory          |
|  OK | 0.88 | 0.95 | TxfAllocateAndStoreNameForTxLogging    | Length check
|  OK | 0.87 | 0.93 | NtfsRenameToPrivateDir                 | Length check
|  OK | 0.81 | 0.95 | TxfAllocateFullFilePathForChangeNotify | Length check
|     | 0.76 | 0.94 | NtfsCommonSetInformation               |

Three candidates come to the top:
- NtfsRenameToPrivateDir
- TxfAllocateAndStoreNameForTxLogging
- TxfAllocateFullFilePathForChangeNotify

According to `Microsoft`'s `Security Update Guide` from December, four `CVE`s are related to `NTFS`:
- CVE-2021-43229: Windows NTFS Elevation of Privilege Vulnerability
- CVE-2021-43230: Windows NTFS Elevation of Privilege Vulnerability
- CVE-2021-43231: Windows NTFS Elevation of Privilege Vulnerability
- CVE-2021-43240: NTFS Set Short Name Elevation of Privilege Vulnerability

`CVE-2021-43240`, seems to be related to `NtSetShortNameInfo`.

`NtfsRenameToPrivateDir`, `TxfAllocateAndStoreNameForTxLogging` and `TxAllocateFullFilePathForChangeNotify` have all three the same new length check, and seem to be related to `CVE-2021-43229`, `CVE-2021-43230` and `CVE-2021-43231`, not necessarily in this order. Currently, it is not possible to know which is which, `Microsoft` is a little bit greedy about these information.

### Analysis

In all three `CVE`s an integer overflow occurs during allocation size computation (directory path length + file name length), leading to a pool-based buffer overflow with the next two `memmove` of directory path and file name.

## Second part - The Path

### First try: `NtfsRenameToPrivateDir`

The path to `NtfsRenameToPrivateDir` is shown below:
```
NtfsCommonSetInformation
       |__________________
       |                  |
       v                  v
NtfsSetLinkInfo   NtfsSetRenameInfo
       |__________________|
       |
       v
NtfsRemoveSupersededTarget
       |
       v
NtfsRenameToPrivateDir
```

Foremost, to call `NtfsCommonSetInformation`, just call `NtSetInformationFile`. Then, to go through `NtfsSetLinkInfo` and `NtfsSetRenameInfo`, use respectively `FileLinkInformationEx` and `FileRenameInformationEx` as file information class in `NtSetInformationFile`.

To reach `NtfsRemoveSupersededTarget` through `NtfsSetRenameInfo`, it is necessary to set `FILE_RENAME_REPLACE_IF_EXISTS` and `FILE_RENAME_POSIX_SEMANTICS` flags. Rename a file with the name of an existing one to access to `NtfsRemoveSupersededTarget`. For `NtfsRenameToPrivateDir`, it is a little bit tricky, because the replaced file must be opened by any process.

Unfortunately a length check is done before the call to `NtfsRemoveSupersededTarget`.

The method with `NtfsSetLinkInfo` is similar to `NtfsSetRenameInfo`, only flag's names differs, there meanings still the same. But as well as `NtfsSetRenameInfo` another check is done before the call to `NtfsRemoveSupersededTarget`.

### Second try: `TxfAllocateAndStoreNameForTxLogging`

The path to `TxfAllocateAndStoreNameForTxLogging` is shown below:
```
NtfsCommonCreate
      |
      v
NtfsCreateNewFile
      |
      v
TxfNewFileCreate
      |
      v
TxfAllocateAndStoreNameForTxfLogging
```

Foremost, to call `NtfsCommonCreate`, just call `CreateFile`.

The `TxfNewFileCreate` function is prefixed with `Txf` which means "Transactional NTFS" and is called when a transacted file is created. `TxfAllocateAndStoreNameForTxfLogging` is called during the process in order to store the path of the transacted file.

Only two calls are necessary:
  - CreateTransaction
  - CreateFileTransacted

## Third part - PoC It

Vulnerable code of `TxfAllocateAndStoreNameForTxLogging` is shown below:
```
...
and     di, 2
add     di, [rsi+UNICODE_STRING.Length]                      ; File name
add     di, [rsp+68h+RelativeNormalizedDirectoryPath.Length] ; OVERFLOW HERE
cmp     [rsp+68h+arg_20], r12b
jnz     loc_16592C

movzx   edx, di
add     rdx, size UNICODE_STRING ; NumberOfBytes
mov     ecx, cs:PoolType
or      ecx, 10h        ; PoolType
mov     r8d, 'afxT'     ; Tag
call    cs:__imp_ExAllocatePooliWthTag
...
```

In order to trigger the overflow, it is necessary to create a file with an excessive length, more than `0xFFFF` bytes (`32767` characters).

A problem show up is that a file or directory name cannot be greater than 256 characters - including the NULL character. To solve this one, usage of deep sub folders will be necessary. Weirdly, it is not so easy, even with sub folders created successfully, the sub file cannot be created, certainly due to some checks done earlier.

Using `explorer` bar it is possible to notice the format used to show the directory path. It is not what I expected, instead of using a "classic" path, `explorer` use the old-fashioned format of `DOS`, the `8.3` short format.

Keeping the sub folders creation as before and using short name for sub directories during file creation do the job.

It is important to notice, 16 bytes will be added to the overflowed size, which is the size of the `UNICODE_STRING` that will represent the final path. It is because the requested memory will contain the `UNICODE_STRING` followed by the buffer of this `UNICODE_STRING`.

Method:
  - Create sub directories with long name
  - Create file with a long name and short names for the directory path

Current conditions:
  - The overflow overwrite the equivalent of 64KB
  - Allocated memory size is up to 0x20C bytes
  - Allocated memory is in paged pool

## Fourth part - Leads

An interesting [write-up][__SYNACKTIV_WRITE_UP__] from `Synacktiv` at `SSTIC 2020` could be an idea to dig, by targeting `VS Heap`.

The `CVE-2020-17087` a similar case of exploitation has been presented by [`PixiePoint Security`][__PIXIEPOINT_SECURITY__] using the technique mentioned above.

[__SYNACKTIV_WRITE_UP__]:https://www.sstic.org/media/SSTIC2020/SSTIC-actes/pool_overflow_exploitation_since_windows_10_19h1/SSTIC2020-Article-pool_overflow_exploitation_since_windows_10_19h1-bayet_fariello.pdf
[__PIXIEPOINT_SECURITY__]:https://www.pixiepointsecurity.com/blog/nday-cve-2020-17087.html
