# ⚠️ H2 Database RCE Exploit PoC (CVE-2021-42392)

This repository provides a minimal and controlled environment to test the **H2 Database Remote Code Execution vulnerability (CVE-2021-42392)** using the `CREATE ALIAS` feature. Unlike many demonstrations, this exploit targets the H2 TCP service directly (typically on port 9092), without relying on the H2 Web Console.

> 🛑 **For educational and testing purposes only. Do not use on systems you don't own or have explicit permission to test.**

---

## Description

CVE-2021-42392 is a critical vulnerability in H2 Database versions prior to 2.0.206 that allows remote code execution via `CREATE ALIAS` if the database is exposed over TCP or via the Web Console.

This project includes:

- A vulnerable H2 database server running version `2.0.202`
- A Python exploit script using `jaydebeapi` and `JPype`
- Docker containers to simplify setup



## Requirements

With Docker:
- [Docker](https://www.docker.com/)
- [Docker Compose](https://docs.docker.com/compose/)


If running the exploit outside Docker:
- Python 3 (with jpype and jaydebeapi modules)
- Java
- [h2-jar](https://repo1.maven.org/maven2/com/h2database/h2/2.0.202/h2-2.0.202.jar)


## How to Run

### 1. Clone the repository

```bash
git clone https://github.com/Be-Innova/CVE-2021-42392-exploit-lab
cd h2-cve-2021-42392-poc
```

### 2. Build and start containers
```bash
docker compose build
docker compose up -d
```

### 3. Launch the exploit
```bash
docker compose exec client bash

python3 h2_exploit.py --url jdbc:h2:tcp://h2-vulnerable\:9092/~/test --cmd "touch /tmp/pwned" --jar /jars/h2.jar
```

---

## Exploit Script Usage

```bash
python3 h2_exploit.py --url <jdbc-url> --cmd "<command>" --jar "path-to-jar"
```

Arguments:

- `--url`: JDBC URL of the vulnerable H2 instance (e.g. jdbc:h2:tcp://192.168.1.100\\:9092/~/test)

- `--cmd`: Command to execute on the vulnerable server

- `--jar`: Optional path to H2 driver JAR (default: /jars/h2.jar)

### 🤐​ Requirements to exploit the RCE in other environments

- `Port 9092` open of the vulnerable H2 Database
- Credentials of the database
- `javac` compiler installed on the server running the vulnerable database

---

### Disclaimer

This code is provided as-is for educational and ethical penetration testing in isolated environments. Do not use it on unauthorized systems. The author takes no responsibility for misuse.

---


### References

https://nvd.nist.gov/vuln/detail/CVE-2021-42392

https://www.h2database.com/html/main.html