import socket
import sys

def grab_ssh_banner(host, port=22, timeout=5):
    try:
        s = socket.socket()
        s.settimeout(timeout)
        s.connect((host, port))
        banner = s.recv(1024).decode(errors="ignore").strip()
        s.close()
        return banner
    except Exception as e:
        return f"[!] Error: {e}"

def check_vuln(banner):
    if "OpenSSH" in banner:
        try:
            version_str = banner.split("OpenSSH_")[1].split(" ")[0]
            version = version_str.split("p")[0]  # ambil sebelum patch-level
            major, minor = map(int, version.split(".")[:2])

            # rentan kalau versi >=6.2 dan <8.8
            if (major == 6 and minor >= 2) or (major > 6 and (major < 8 or (major == 8 and minor < 8))):
                return f"[!!!] VULNERABLE (CVE-2021-41617) → {version_str}"
            else:
                return f"[+] OpenSSH {version_str} → Tidak rentan untuk CVE-2021-41617"
        except Exception:
            return "[?] Gagal parsing versi dari banner"
    return "[?] Bukan OpenSSH atau banner tidak jelas"

if __name__ == "__main__":
    if len(sys.argv) < 2:
        print(f"Usage: python3 {sys.argv[0]} <host> [port]")
        sys.exit(1)

    host = sys.argv[1]
    port = int(sys.argv[2]) if len(sys.argv) > 2 else 22

    print(f"[*] Grabbing SSH banner from {host}:{port} ...")
    banner = grab_ssh_banner(host, port)
    print(f"[+] Banner: {banner}")
    print(check_vuln(banner))
