# easy-exploits

The current repository contains exploits of different CVE IDs that were identified in the past by me (CVE-2021-37910, CVE-2021-40288, CVE-2021-41435, CVE-2021-41436,  CVE-2021-41437, CVE-2021-41441, CVE-2021-41442, CVE-2021-41445, CVE-2021-41449, CVE-2021-41450, CVE-2021-41451, CVE-2021-41753, CVE-2021-41788, CVE-2021-46353, CVE-2022-41540, CVE-2022-41541).


## Motivation

The main purpose of this repository is to give an easy access to these exploits, since they are mentioned in each published manuscript and needed to be formatted, in order to be executed.


## Repository overview

Each directory is separated based on the affected protocol that the attack is escalated and the relevant CVE ID.
```
├── README.md
├── Web
│   ├── ASUS
|   |     ├── CVE-2021-41435
|   |     ├── CVE-2021-41436
|   |     ├── CVE-2021-41437
|   |     ├── HTTP-smuggling
|   |     ├── Stored XSS
│   ├── D-Link
|   |     ├── CVE-2021-41440
|   |     ├── CVE-2021-41441
|   |     ├── CVE-2021-41442
|   |     ├── CVE-2021-41443
|   |     ├── CVE-2021-41445
|   |     ├── CVE-2021-46352
|   |     ├── CVE-2021-46353
│   └── Netgear
|   |     ├── CVE-2021-41449
│   └── TP-Link
|   |     ├── CVE-2021-41450
|   |     ├── CVE-2021-41451
|   |     ├── CVE-2022-41540
|   |     ├── CVE-2022-41541
│   └── Xiaomi
|   |     ├── Clickjacking
|   |     ├── Out-of-band
└── Wi-Fi (WPA3-SAE) (CVE-2021-37910, CVE-2021-40288, CVE-2021-41753, and CVE-2021-41788)
    ├── README.md
    ├── Broadcom
    ├── Qualcomm
    └── MediaTek
```

## Running instructions

For Web attacks, any curl tool stable version should be suffice. For Wi-Fi atacks, Python3 and Scapy 2.4.1 should be enough to use an exploit.


## More resources

The following refers to the original publication manuscripts, in which these exploits were taken, in case anyone needs more information for a vulnerability. For the DoS attacks on Wi-Fi, check [this](https://www.sciencedirect.com/science/article/pii/S221421262100243X) paper. While, for the Web attacks, [this](https://www.hindawi.com/journals/scn/2022/1833062/) paper.


MIT License

Copyright (c) 2022 Efstratios Chatzoglou

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

