# CVE-2021-3493
Ubuntu OverlayFS Local Privesc

## Affected Versions

- Ubuntu 20.10
- Ubuntu 20.04 LTS
- Ubuntu 19.04
- Ubuntu 18.04 LTS
- Ubuntu 16.04 LTS
- Ubuntu 14.04 ESM

## Usage

- ```gcc exploit.c -o exploit```
- ```./exploit```

## Description

"Ubuntu specific issue in the overlayfs file system in the Linux kernel where it did not properly validate the application of file system capabilities with respect to user namespaces. A local attacker could use this to gain elevated privileges, due to a patch carried in Ubuntu to allow unprivileged overlayfs mounts." [- Ubuntu Security](https://ubuntu.com/security/CVE-2021-3493)

Fixed in Linux 5.11

## References
- https://ssd-disclosure.com/ssd-advisory-overlayfs-pe/
- https://ubuntu.com/security/CVE-2021-3493
- https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=7c03e2cda4a584cadc398e8f6641ca9988a39d52
- https://www.openwall.com/lists/oss-security/2021/04/16/1

## Disclaimer
I am not the author of this exploit. I have not made any modifications to the PoC found here: https://ssd-disclosure.com/ssd-advisory-overlayfs-pe/.
