# CVE-2021-34824 repro
## reproducing an old istio bug

This set of scripts and manifests will aid in exploring [an old Istio security issue](https://istio.io/latest/news/security/istio-security-2021-007/) which allowed malicious Istio users to access Kubernetes secrets they should not have access to. This reproduction is modeled on [this blog post](https://www.cyberark.com/resources/threat-research-blog/what-i-learned-from-analyzing-a-caching-vulnerability-in-istio) which has some problems. See [this blog post](https://rob.salmond.ca/reproing-a-repro-of-an-old-istio-vulnerability/) for details.

## Using

### See the vulnerability

1. Run `./one_time_setup.sh` to download the necessary binaries.
1. Run `./deploy_test.sh` to deploy the vulnerable version of istio in a vulnerable configuration.
1. Run `./evaluate_test.sh` to examine the results of the test.


### See the fix

1. Edit `istio_versions.sh` and switch the `ISTIO_VERSION` variable from `${ISTIO_VULN}` to `${ISTIO_SAFE}`.
1. Run `./deploy_test.sh` to deploy the fixed version of istio in the same vulnerable configuration.
1. Run `./rollpods.sh` to bounce the gateway pods so they pick up the new version.
1. Run `./check_version.sh` to verify that the fixed version of istio is running.
1. Run `./evaluate_test.sh` to examine the results again.
