/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.NodeOrRelationship;
import org.neo4j.shell.kernel.apps.TransactionProvidingApp;

public class Rmnode
extends TransactionProvidingApp {
    public Rmnode() {
        this.addOptionDefinition("f", new OptionDefinition(OptionValueType.NONE, "Force deletion, will delete all relationships prior to deleting the node"));
    }

    @Override
    public String getDescription() {
        return "Deletes a node from the graph. If no node-id argument is given the current node is deleted";
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        NodeOrRelationship node = null;
        if (parser.arguments().isEmpty()) {
            node = this.getCurrent(session);
        } else {
            long id = Integer.parseInt(parser.arguments().get(0));
            try {
                node = NodeOrRelationship.wrap(this.getNodeById(id));
            }
            catch (NotFoundException e) {
                throw new ShellException("No node " + id + " found");
            }
        }
        if (!node.isNode()) {
            out.println((Serializable)((Object)"Please select a node to delete"));
            return Continuation.INPUT_COMPLETE;
        }
        boolean forceDeletion = parser.options().containsKey("f");
        if (forceDeletion) {
            for (Relationship relationship : node.asNode().getRelationships()) {
                out.println((Serializable)((Object)("Relationship " + Rmnode.getDisplayName(this.getServer(), session, relationship, true, false) + " deleted")));
                relationship.delete();
            }
        }
        if (node.asNode().hasRelationship()) {
            throw new ShellException(Rmnode.getDisplayName(this.getServer(), session, node.asNode(), false) + " cannot be deleted because it still has relationships. Use -f to force deletion of its relationships");
        }
        node.asNode().delete();
        return Continuation.INPUT_COMPLETE;
    }
}

