/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.rmi.RemoteException;
import java.util.List;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.TabCompletion;

public class ShellTabCompleter
implements Completer {
    private final ShellClient client;
    private long timeWhenCached;
    private Completer appNameCompleter;

    public ShellTabCompleter(ShellClient client) {
        this.client = client;
    }

    public int complete(String buffer, int cursor, List candidates) {
        if (buffer == null || buffer.length() == 0) {
            return cursor;
        }
        try {
            if (!buffer.contains(" ")) {
                return this.getAppNameCompleter().complete(buffer, cursor, candidates);
            }
            TabCompletion completion = this.client.getServer().tabComplete(this.client.getId(), buffer.trim());
            cursor = completion.getCursor();
            candidates.addAll(completion.getCandidates());
        }
        catch (RemoteException | ShellException e) {
            e.printStackTrace();
        }
        return cursor;
    }

    private Completer getAppNameCompleter() throws RemoteException {
        if (this.timeWhenCached != this.client.timeForMostRecentConnection()) {
            this.timeWhenCached = this.client.timeForMostRecentConnection();
            this.appNameCompleter = new StringsCompleter(this.client.getServer().getAllAvailableCommands());
        }
        return this.appNameCompleter;
    }
}

