/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Map;
import org.neo4j.shell.CtrlCHandler;
import org.neo4j.shell.InterruptSignalHandler;
import org.neo4j.shell.Output;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.impl.AbstractClient;
import org.neo4j.shell.impl.SystemOutput;

public class SameJvmClient
extends AbstractClient {
    private final Output out;
    private final ShellServer server;

    public SameJvmClient(Map<String, Serializable> initialSession, ShellServer server, CtrlCHandler ctrlcHandler) throws ShellException {
        this(initialSession, server, new SystemOutput(), ctrlcHandler);
    }

    public SameJvmClient(Map<String, Serializable> initialSession, ShellServer server, Output out) throws ShellException {
        this(initialSession, server, out, InterruptSignalHandler.getHandler());
    }

    public SameJvmClient(Map<String, Serializable> initialSession, ShellServer server, Output out, CtrlCHandler ctrlcHandler) throws ShellException {
        super(initialSession, ctrlcHandler);
        this.out = out;
        this.server = server;
        try {
            this.sayHi(server);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Will not happen since this is in the same JVM", e);
        }
        this.init();
        this.updateTimeForMostRecentConnection();
    }

    @Override
    public Output getOutput() {
        return this.out;
    }

    @Override
    public ShellServer getServer() {
        return this.server;
    }
}

