import requests

def check_flysystem_version(url):
    try:
        response = requests.get(f"{url}/vendor/composer/installed.json")
        
        if response.status_code == 200:
            installed = response.json()
            for package in installed:
                if "league/flysystem" in package.get("name", ""):
                    version = package.get("version", "unknown")
                    print(f"[+] Flysystem detected: {version}")

                    if version < "1.1.4" or version.startswith("2.0"):
                        print("[!] Vulnerable version detected! Upgrade to 1.1.4 or 2.1.1+")
                    else:
                        print("[-] Flysystem version is safe.")
                    return
            print("[-] Flysystem not found.")
        else:
            print("[-] Unable to access composer/installed.json.")

    except Exception as e:
        print(f"[!] Error: {e}")

if __name__ == "__main__":
    target_url = input("Enter the target URL (e.g., http://example.com): ")
    check_flysystem_version(target_url)
