### Public Reference for CVE-2021-31728
###### Affected Product: MalwareFox AntiMalware 2.74.0.150
###### Affected Component: zam64.sys, zam32.sys
###### Vulnerability Type: Local, incorrect access control
###### Impact: High, arbitrary ring 0 code execution
#### Description
Incorrect access control in zam64.sys, zam32.sys in MalwareFox AntiMalware 2.74.0.150 allows a non-privileged process to open a handle to \\.\ZemanaAntiMalware, register itself with the driver by sending IOCTL 0x80002010, allocate executable memory using a flaw in IOCTL 0x80002040, install a hook with IOCTL 0x80002044 and execute the executable memory using this hook with IOCTL 0x80002014 or 0x80002018, this exposes ring 0 code execution in the context of the driver allowing the non-privileged process to elevate privileges.
#### Technical Details
IOCTL 0x80002040 exposes kernel memory allocation in the NonPagedPool where a user-mode string is copied into the target buffer, this buffer can be used for shellcode by forcing the input data to be larger than 0x1000 bytes, a buffer larger than 0x834 will cause a STATUS_ACCESS_VIOLATION and so you must trick the IOCTL into failing and forgetting to free the buffer, you can then search SystemBigPoolInformation for the newly allocated buffer with the shellcode. IOCTL 0x80002018 instructs the driver to setup a hook function which contains fixed prologue code (passed from a user-mode buffer and copied until the first jmp instruction) for a miniport driver's IRP_MJ_SCSI_HANDLER, this hook is installed and used when either IOCTL 0x80002014 or 0x80002018 are sent, these IOCTL's send SCSI requests to a driver specified by the user input, but also install the hook function before-hand and remove it after. This can by leveraged by:  
* opening a handle to \\.\ZemanaAntiMalware
* registering with the driver by sending IOCTL 0x80002010
* allocating kernel memory in the NonPagedPool by abusing a flaw in IOCTL 0x80002040
* searching for this kernel memory by enumerating SystemBigPoolInformation
* installing a miniport driver hook prologue fix using IOCTL 0x80002044  
* executing the miniport driver hook with IOCTL 0x80002014 or IOCTL 0x80002018
###### A proof of concept is available at [kernel_exec/main.c](kernel_exec/main.c).
