# CVE-2021-30862

In 2021, CodeColorist released his writeups on the [Mistuned vulnerabilities](https://codecolor.ist/2021/08/04/mistuned-part-i/), a series of vulnerabilities affecting the iTunes Store allowing for one-click remote code execution. Notably, he demonstrated popping calc with no memory corruption at all, but with just a logic bug. During this time period, I was investigating URL schemes in various apps, because 2 years before, I had reported a [security issue regarding App Store's itms-services:// URL scheme](https://support.apple.com/en-us/HT211850). One URL scheme I had found that was pretty similar was iTunes U's itms-itunesu:// URL scheme. At the time though, I had no idea that it accepted user supplied input and thought it was only used to open the app, but later I realized this was not the case.

Upon reading his writeup, one thing caught my eye in particular: Jung Hoon Lee's sandbox escape using itmss:// during Pwn2Own 2014. At the time, iTunes Store accepted arbitrary URLs and would gladly load them into its SUWebView, even if they were not from Apple (CVE-2014-8840). At this point, you might be able to guess where I'm headed. I noticed that itmss:// was very similar to iTunes U's URL scheme, so I decided to see if iTunes U would load up google.com into it's web view. And lo and behold, it did. And then I decided to try using the same iTunes API that was used by Mistuned bugs in an attempt to pop calc, fully not expecting it to work, but to my greatest surprise, it did. It turns out that both iTunes Store and iTunes U share this same API. And what about the UAF from Mistuned? Was that in iTunes U too? Turns out it was as well, and I was able to create a proof-of-concept that crashes iTunes U by double freeing memory (POC_6.html). I attached some of the POCs I sent Apple as well as an attempt at a [fakeobj/addrof primitive](http://www.phrack.org/papers/attacking_javascript_engines.html) from this vulnerability in main.js with help from the Mistuned write-up, tho iirc I don't think I got the fakeobj primitive working fully. You can read CodeColorist's write-up for more information on the impact of these vulnerabilities, but in short, they allow for a lot of sensitive data to be retrieved from the victim as well as potential 1-click RCE.

# Disclosure Timeline
* My initial report to product-security: 8/6/2021
* Vulnerability acknowledged and reproduced ~ 8/23/2021
* [Patch released in 3.8.3 update and CVE ID CVE-2021-30862](https://support.apple.com/en-us/103152) given: 9/15/2021
* $10,000 bounty awarded: 12/23/2021
