@echo off
echo ====================================================
echo  CVE-2021-30809 WebKit UAF PoC Server
echo  Target: PlayStation 4 Browser (WebKit 605.1.15)
echo ====================================================
echo.

echo [INFO] Checking Python installation...
python --version >nul 2>&1
if errorlevel 1 (
    echo [ERROR] Python not found! Please install Python 3.x
    echo [INFO] Download from: https://www.python.org/downloads/
    pause
    exit /b 1
)

echo [INFO] Python found! Starting server...
echo.
echo [NETWORK] Resolving local IP...
for /f %%i in ('python - <<PY
import socket,ipaddress
# tenta ip via udp
try:
    s=socket.socket(socket.AF_INET,socket.SOCK_DGRAM)
    s.connect(("1.1.1.1",80))
    detected=s.getsockname()[0]
    s.close()
except Exception:
    detected='127.0.0.1'

RFC1918=[ipaddress.ip_network('10.0.0.0/8'),ipaddress.ip_network('172.16.0.0/12'),ipaddress.ip_network('192.168.0.0/16')]

def is_valid(ip):
    try:
        ipo=ipaddress.ip_address(ip)
        if ipo.version!=4 or ipo.is_loopback or ipo.is_link_local or ipo.is_unspecified: return False
        if ipo in ipaddress.ip_network('100.64.0.0/10'): return False
        return True
    except: return False

def is_rfc1918(ip):
    try:
        ipo=ipaddress.ip_address(ip)
        return any(ipo in n for n in RFC1918)
    except: return False

cands=[detected]
try:
    hn=socket.gethostname()
    for fam,_,_,_,sa in socket.getaddrinfo(hn,None):
        if fam==socket.AF_INET: cands.append(sa[0])
    for ip in socket.gethostbyname_ex(hn)[2]: cands.append(ip)
except: pass

cands=[ip for ip in cands if is_valid(ip) and is_rfc1918(ip)]
# preferisci 192.168, poi 10, poi 172.16-31
cands=sorted(set(cands), key=lambda ip: 0 if ip.startswith('192.168.') else (1 if ip.startswith('10.') else (2 if ipaddress.ip_address(ip) in ipaddress.ip_network('172.16.0.0/12') else 3)))
print(cands[0] if cands else detected)
PY') do set LOCALIP=%%i
if "%LOCALIP%"=="" set LOCALIP=localhost

echo [NETWORK] Server will be accessible at:
echo           http://localhost:8080
echo           http://%LOCALIP%:8080
echo.
echo [PS4] To test on PS4:
echo       1. Connect PS4 to the same network
echo       2. Open PS4 Browser
echo       3. Navigate to http://%LOCALIP%:8080
echo       4. Click the exploit buttons
echo.
echo [WARNING] This exploit may cause browser crashes!
echo           Use only on dedicated test systems.
echo.
echo Starting server in 3 seconds...
timeout /t 3 /nobreak >nul

python server.py

echo.
echo [INFO] Server stopped.
pause 