## CVE-2021-30809 — Apple WebKit Use-After-Free Vulnerability (Crash PoC)


https://github.com/user-attachments/assets/e81f8a01-d48d-44cc-a38f-ce59b01222d5


### Overview
This repository contains a minimal crash-inducing harness for CVE-2021-30809, a use-after-free (UAF) vulnerability in WebKit. The PoC exercises the vulnerable code path by processing crafted web content and aims to reliably trigger a browser crash (not a full exploit). It is intended strictly for research, debugging, and regression testing.

- Target engine: WebKit (e.g., WebKitGTK / WPE WebKit, legacy forks embedded in devices)
- Example device under test: PlayStation 4 Browser (WebKit 605.1.15)
- Purpose: deterministic crash trigger to validate exposure and verify fixes/mitigations

### Affected components and versions
- WebKitGTK and WPE WebKit before 2.32.4 are reported as vulnerable.
- Apple platforms (Safari 15, iOS/iPadOS/tvOS/watchOS 15, ps4 6.00 to 12.52) contain the upstream fix according to vendor advisories.

Always consult vendor/security advisories for the definitive scope.

### PoC design
- The HTML invokes a JavaScript routine (`triggerCrash`) that stresses WebKit’s internationalization/date-time formatting code paths using crafted options and aggressive iteration.
- The sequence is designed to amplify lifetime/GC pressure and expose a UAF crash when the engine is vulnerable.
- No memory corruption primitives are harvested. The PoC intentionally avoids ROP/spray or privilege-escalation steps.

### Repository layout
- `exploit.html`: Entry point that wires UI to the PoC routine.
- `poc.js`: JavaScript harness that triggers the crash condition.
- `server.py`: Lightweight HTTP server with explicit routing, CORS, and simple logging.
- `start_server.bat`: Convenience launcher for Windows.

### Requirements
- Python 3.x
- A desktop OS or a device under test on the same LAN as the server

### Running the server
- Windows (recommended quick start):
  1. Double-click `start_server.bat` or run it from a terminal.
  2. The script resolves a suitable RFC1918 LAN IP and prints the access URLs, e.g. `http://localhost:8080` and `http://<LAN_IP>:8080`.

- Cross‑platform:
  1. Open a terminal in the project directory.
  2. Run: `python server.py`
  3. Navigate to the printed URL, typically `http://localhost:8080`.

### PS4 testing (example target)
1. Ensure the PS4 is connected to the same LAN as the server.
2. Open the PS4 Browser.
3. Browse to `http://<server-lan-ip>:8080`.
4. Click “Run Crash Test”.

### Server details
- Bind: `0.0.0.0:8080`
- Endpoints:
  - `/` or `/index.html` → serves `exploit.html`
  - `/poc.js` → serves the PoC harness
  - `/server-info.js` → exposes `{ ip, port, url, ips }` derived from local enumerations
  - `/ip` → returns the selected server IP as plain text
  - `/favicon.ico` → 204
- Features:
  - RFC1918 IP selection with preference order: `192.168.0.0/16`, then `10.0.0.0/8`, then `172.16.0.0/12`
  - CORS headers enabled for GET/POST/OPTIONS
  - Simple logging with User-Agent hints (flags PS4 Browser)

### Notes and safety
- This PoC is crash‑oriented; it does not attempt code execution.
- Use only in controlled environments and on devices you own and are authorized to test.
- Expect instability and browser crashes on vulnerable builds.

### References
- WebKitGTK and WPE WebKit Security Advisory WSA-2021-0007: https://webkitgtk.org/security/WSA-2021-0007.html
- NVD entry for CVE-2021-30809: https://nvd.nist.gov/vuln/detail/CVE-2021-30809
- Amazon Linux Security Center: https://alas.aws.amazon.com/cve/html/CVE-2021-30809.html
- Ubuntu CVE notice: https://ubuntu.com/security/CVE-2021-30809
- SUSE CVE notice: https://www.suse.com/security/cve/CVE-2021-30809.html
