//
// Copyright © 2022 osy. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

#import <Foundation/Foundation.h>
#import "WVUVCDeviceDelegate.h"

NS_ASSUME_NONNULL_BEGIN

@interface WVUVCDevice : NSObject

@property (class, readonly) NSArray<WVUVCDevice *> *allDevices;
@property (readonly) NSString *name;
@property (nullable, weak) id<WVUVCDeviceDelegate> delegate;

- (BOOL)startStreamWithError:(NSError **)error;
- (void)stopStream;

@end

NS_ASSUME_NONNULL_END
